<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/tclicmr/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

            $connection = getConnection();
            $dbh = $connection->prepare('SELECT * FROM tclicmr WHERE cliente = ?');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(my_json_encode($recordset));
        }
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }

});


$app->get('/tclicmr/:codigo', function($codigo) use($app)
{

    try{

        $connection = getConnection();
        $dbh = $connection->prepare('SELECT * FROM tclicmr WHERE codigo = ? ');
        $dbh->bindParam(1, $codigo);
        $dbh->execute();
        $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

        $connection = null;

        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(my_json_encode($recordset));

    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }

});

$app->post('/tclicmr/', function() use($app)
{

    $codigo         =        siNull($app->request->post('CODIGO'),'');   
    $comercio       =        siNull($app->request->post('COMERCIO'),'');  
    $cliente        =        siNull($app->request->post('CLIENTE'),'');  
    $fecha          =        siNull($app->request->post('FECHA'),'');  
    $baja           =        siNull($app->request->post('BAJA'),'1900-01-01'); 


    try{
        $connection = getConnection();
        $dbh = $connection->prepare("SELECT * FROM tclicmr WHERE CODIGO=?"  );
        $dbh->bindParam(1, $codigo,PDO::PARAM_STR);

        $dbh->execute();
        $recordcount = $dbh->rowCount();
        $sql = '';

//        $app->response->body($recordcount);

        if($recordcount==0){

            $sql = $sql.'INSERT INTO tclicmr ( ';
            $sql = $sql.'codigo         , ';                    //01
            $sql = $sql.'comercio       , ';                    //02
            $sql = $sql.'cliente        , ';                    //03
            $sql = $sql.'fecha          , ';                    //04
            $sql = $sql.'baja           , ';                    //05
            $sql = $sql.'tipocli          ';                    //06
            $sql = $sql.') VALUES( ';
            $sql = $sql.':codigo         , ';                     //01
            $sql = $sql.':comercio       , ';                     //02
            $sql = $sql.':cliente        , ';                     //03
            $sql = $sql.':fecha          , ';                     //04
            $sql = $sql.':baja           , ';                     //05
            $sql = $sql.':tipocli          ';                     //06
            $sql = $sql.') ';

        }else{


            $sql = $sql.'UPDATE tclicmr SET ';
            $sql = $sql.'cliente         = :cliente         , ';    //03
            $sql = $sql.'fecha           = :fecha           , ';    //04
            $sql = $sql.'tipocli         = :tipocli         , ';    //05
            $sql = $sql.'fecha           = :fecha           , ';    //06
            $sql = $sql.'baja            = :baja            , ';    //07
            $sql = $sql.'WHERE codigo = :codigo ';        // 1

        }

        $dbh = $connection->prepare($sql);

        $dbh->bindParam(':codigo', $codigo);            //          01
        $dbh->bindParam(':comercio', $comercio);            //          02
        $dbh->bindParam(':cliente', $cliente);            //            03
        $dbh->bindParam(':fecha', $fecha);            //        04
        $dbh->bindParam(':tipocli', $tipocli);            //          05
        $dbh->bindParam(':baja', $baja);            //              06

        $dbh->execute();
        $connection = null;


        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(json_encode(array(array('estado'=>'OK'))));


        }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }


});

$app->delete('/tclicmr/:codigo',function($codigo) use($app)
{
    try{

        $connection = getConnection();
        $dbh = $connection->prepare('DELETE FROM tclicmr WHERE codigo = ?');
        $dbh->bindParam(1, $codigo);
        $dbh->execute();

        $connection = null;

        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(json_encode(array(array('estado'=>'OK'))));

    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
