<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/recibos/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

            $connection = getConnection();
            $dbh = $connection->prepare('SELECT rec.* '
                    . 'FROM recibos rec, creditos cre '
                    . 'WHERE rec.prestam=cre.prestam '
                    . 'AND cre.cliente = ?');

            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(my_json_encode($recordset));
        }

    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/recibos/', function() use($app)
{

    $codigo         =        siNull($app->request->post('CODIGO'),'');  //      01
    $prestam        =        siNull($app->request->post('PRESTAM'),'');  //     02
    $cliente        =        siNull($app->request->post('CLIENTE'),'');  //     03
    $comercio       =        siNull($app->request->post('COMERCIO'),'');  //    04
    $cuota          =        siNull($app->request->post('CUOTA'),'');  //       05
    $fecha          =        siNull($app->request->post('FECHA'),'');  //       06
    $importe        =        siNull($app->request->post('IMPORTE'),'');  //     07
    $recargo        =        siNull($app->request->post('RECARGO'),'');  //     08
    $lote           =        siNull($app->request->post('LOTE'),'');  //        09
    $recorri        =        siNull($app->request->post('RECORRI'),'');  //     10
    $factura        =        siNull($app->request->post('FACTURA'),'');  //     11
    $tipfac         =        siNull($app->request->post('TIPFAC'),'');  //      12
    $fecproc        =        siNull($app->request->post('FECPROC'),'');  //     13
    $descuento      =        siNull($app->request->post('DESCUENTO'),'');  //   14
    $renovacion     =        siNull($app->request->post('RENOVACION'),'');  //  15
    $tipocance      =        siNull($app->request->post('TIPOCANCE'),'');  //   16
    $estacion       =        siNull($app->request->post('ESTACION'),'');  //    17
    $cargesref      =        siNull($app->request->post('CARGESREF'),'');  //   18
    $cargespagu     =        siNull($app->request->post('CARGESPAGU'),'');  //  19
    $observac       =        siNull($app->request->post('OBSERVAC'),'');  //    20
    $netopun        =        siNull($app->request->post('NETOPUN'),'');  //     21
    $descpun        =        siNull($app->request->post('DESCPUN'),'');  //     22
    $carges         =        siNull($app->request->post('CARGES'),'');  //      23
    $netocge        =        siNull($app->request->post('NETOCGE'),'');  //     24
    $desccge        =        siNull($app->request->post('DESCCGE'),'');  //     25
    $autoriza       =        siNull($app->request->post('AUTORIZA'),'');  //    26
    $usuario        =        siNull($app->request->post('USUARIO'),'');  //     27
    $falta          =        siNull($app->request->post('FALTA'),'');  //       28
    $halta          =        siNull($app->request->post('HALTA'),'');  //       29
    $formapag       =        siNull($app->request->post('FORMAPAG'),'');  //    30
    $descpag        =        siNull($app->request->post('DESCPAG'),'');  //     31
    
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {



            $connection = getConnection();
            $dbh = $connection->prepare('SELECT codigo, prestam, cuota '
                    . 'FROM recibos '
                    . 'WHERE codigo = ? '
                    . 'AND prestam = ? '
                    . 'AND cuota= ? ');
            $dbh->bindParam(1, $codigo);
            $dbh->bindParam(2, $prestam);
            $dbh->bindParam(3, $cuota);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';

            if($recordcount==0){

                $sql = $sql.'INSERT INTO recibos ( ';
                $sql = $sql.'codigo         , ';                    //01
                $sql = $sql.'prestam        , ';                    //02
                $sql = $sql.'cliente        , ';                    //03
                $sql = $sql.'comercio       , ';                    //04
                $sql = $sql.'cuota          , ';                    //05
                $sql = $sql.'fecha          , ';                    //06
                $sql = $sql.'importe        , ';                    //07
                $sql = $sql.'recargo        , ';                    //08
                $sql = $sql.'lote           , ';                    //09
                $sql = $sql.'recorri        , ';                    //10
                $sql = $sql.'factura        , ';                    //11
                $sql = $sql.'tipfac         , ';                    //12
                $sql = $sql.'fecproc        , ';                    //13
                $sql = $sql.'descuento      , ';                    //14
                $sql = $sql.'renovacion     , ';                    //15
                $sql = $sql.'tipocance      , ';                    //16
                $sql = $sql.'estacion       , ';                    //17
                $sql = $sql.'cargesref      , ';                    //18
                $sql = $sql.'cargespagu     , ';                    //19
                $sql = $sql.'observac       , ';                    //20
                $sql = $sql.'netopun        , ';                    //21
                $sql = $sql.'descpun        , ';                    //22
                $sql = $sql.'carges         , ';                    //23
                $sql = $sql.'netocge        , ';                    //24
                $sql = $sql.'desccge        , ';                    //25
                $sql = $sql.'autoriza       , ';                    //26
                $sql = $sql.'usuario        , ';                    //27
                $sql = $sql.'falta          , ';                    //28
                $sql = $sql.'halta          , ';                    //29
                $sql = $sql.'formapag       , ';                    //30
                $sql = $sql.'descpag          ';                    //31
                $sql = $sql.') VALUES( ';
                $sql = $sql.':codigo         , ';                     //01
                $sql = $sql.':prestam        , ';                     //02
                $sql = $sql.':cliente        , ';                     //03
                $sql = $sql.':comercio       , ';                     //04
                $sql = $sql.':cuota          , ';                     //05
                $sql = $sql.':fecha          , ';                     //06
                $sql = $sql.':importe        , ';                     //07
                $sql = $sql.':recargo        , ';                     //08
                $sql = $sql.':lote           , ';                     //09
                $sql = $sql.':recorri        , ';                     //10
                $sql = $sql.':factura        , ';                     //11
                $sql = $sql.':tipfac         , ';                     //12
                $sql = $sql.':fecproc        , ';                     //13
                $sql = $sql.':descuento      , ';                     //14
                $sql = $sql.':renovacion     , ';                     //15
                $sql = $sql.':tipocance      , ';                     //16
                $sql = $sql.':estacion       , ';                     //17
                $sql = $sql.':cargesref      , ';                     //18
                $sql = $sql.':cargespagu     , ';                     //19
                $sql = $sql.':observac       , ';                     //20
                $sql = $sql.':netopun        , ';                     //21
                $sql = $sql.':descpun        , ';                     //22
                $sql = $sql.':carges         , ';                     //23
                $sql = $sql.':netocge        , ';                     //24
                $sql = $sql.':desccge        , ';                     //25
                $sql = $sql.':autoriza       , ';                     //26
                $sql = $sql.':usuario        , ';                     //27
                $sql = $sql.':falta          , ';                     //28
                $sql = $sql.':halta          , ';                     //29
                $sql = $sql.':formapag       , ';                     //30
                $sql = $sql.':descpag          ';                     //31
                $sql = $sql.') ';


              $dbh = $connection->prepare($sql);
  
              $dbh->bindParam(':codigo', $codigo);            //            01
              $dbh->bindParam(':prestam', $prestam);            //          02
              $dbh->bindParam(':cliente', $cliente);            //          03
              $dbh->bindParam(':comercio', $comercio);            //        04
              $dbh->bindParam(':cuota', $cuota);            //              05
              $dbh->bindParam(':fecha', $fecha);            //              06
              $dbh->bindParam(':importe', $importe);            //          07
              $dbh->bindParam(':recargo', $recargo);            //          08
              $dbh->bindParam(':lote', $lote);            //                09
              $dbh->bindParam(':recorri', $recorri);            //          10
              $dbh->bindParam(':factura', $factura);            //          11
              $dbh->bindParam(':tipfac', $tipfac);            //            12
              $dbh->bindParam(':fecproc', $fecproc);            //          13
              $dbh->bindParam(':descuento', $descuento);            //      14
              $dbh->bindParam(':renovacion', $renovacion);            //    15
              $dbh->bindParam(':tipocance', $tipocance);            //      16
              $dbh->bindParam(':estacion', $estacion);            //        17
              $dbh->bindParam(':cargesref', $cargesref);            //      18
              $dbh->bindParam(':cargespagu', $cargespagu);            //    19
              $dbh->bindParam(':observac', $observac);            //        20
              $dbh->bindParam(':netopun', $netopun);            //          21
              $dbh->bindParam(':descpun', $descpun);            //          22
              $dbh->bindParam(':carges', $carges);            //            23
              $dbh->bindParam(':netocge', $netocge);            //          24
              $dbh->bindParam(':desccge', $desccge);            //          25
              $dbh->bindParam(':autoriza', $autoriza);            //        26
              $dbh->bindParam(':usuario', $usuario);            //          27
              $dbh->bindParam(':falta', $falta);            //              28
              $dbh->bindParam(':halta', $halta);            //              29
              $dbh->bindParam(':formapag', $formapag);            //        30
              $dbh->bindParam(':descpag', $descpag);            //          31
  
              $dbh->execute();
              $connection = null;
            };
            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    }
    catch(PDOException $e)
    {
            echo 'Error: ' . $e->getMessage();
    }
});

$app->delete('/recibos/:codigo/:prestam/:cuota',function($codigo, $prestam, $cuota) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {


            $connection = getConnection();
            $dbh = $connection->prepare('DELETE FROM recibos WHERE codigo = ? '
                    . 'AND prestam = ? '
                    . 'AND cuota = ? ');
            $dbh->bindParam(1, $codigo);
            $dbh->bindParam(2, $prestam);
            $dbh->bindParam(3, $cuota);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
