<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/garantia/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT * FROM garantia WHERE cliente = ?');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/garantia/', function() use($app)
{

    $codigo         =        siNull($app->request->post('CODIGO'),'');  //      01
    $falta          =        siNull($app->request->post('FALTA'),'');  //       02
    $fdesde         =        siNull($app->request->post('FDESDE'),'');  //      03
    $fhasta         =        siNull($app->request->post('FHASTA'),'');  //      04
    $cobertura      =        siNull($app->request->post('COBERTURA'),'');  //   05
    $cliente        =        siNull($app->request->post('CLIENTE'),'');  //     06
    $comercio       =        siNull($app->request->post('COMERCIO'),'');  //    07
    $bien           =        siNull($app->request->post('BIEN'),'');  //        08
    $vendedor       =        siNull($app->request->post('VENDEDOR'),'');  //    09
    $gfabrica       =        siNull($app->request->post('GFABRICA'),'');  //    10
    $factura        =        siNull($app->request->post('FACTURA'),'');  //     11
    $fpago          =        siNull($app->request->post('FPAGO'),'');  //       12
    $referencia     =        siNull($app->request->post('REFERENCIA'),'');  //  13
    $capital        =        siNull($app->request->post('CAPITAL'),'');  //     14
    $total          =        siNull($app->request->post('TOTAL'),'');  //       15
    $usuariob       =        siNull($app->request->post('USUARIOB'),'');  //    16
    $fbaja          =        siNull($app->request->post('FBAJA'),'');  //       17
    $hbaja          =        siNull($app->request->post('HBAJA'),'');  //       18
    $usuario        =        siNull($app->request->post('USUARIO'),'');  //     19
    $fproceso       =        siNull($app->request->post('FPROCESO'),'');  //    20
    $halta          =        siNull($app->request->post('HALTA'),'');  //       21
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT codigo FROM garantia WHERE codigo = ?');
            $dbh->bindParam(1, $codigo);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0){

                $sql = $sql.'INSERT INTO garantia ( ';
                $sql = $sql.'codigo         , ';                    //01
                $sql = $sql.'falta          , ';                    //02
                $sql = $sql.'fdesde         , ';                    //03
                $sql = $sql.'fhasta         , ';                    //04
                $sql = $sql.'cobertura      , ';                    //05
                $sql = $sql.'cliente        , ';                    //06
                $sql = $sql.'comercio       , ';                    //07
                $sql = $sql.'bien           , ';                    //08
                $sql = $sql.'vendedor       , ';                    //09
                $sql = $sql.'gfabrica       , ';                    //10
                $sql = $sql.'factura        , ';                    //11
                $sql = $sql.'fpago          , ';                    //12
                $sql = $sql.'referencia     , ';                    //13
                $sql = $sql.'capital        , ';                    //14
                $sql = $sql.'total          , ';                    //15
                $sql = $sql.'usuariob       , ';                    //16
                $sql = $sql.'fbaja          , ';                    //17
                $sql = $sql.'hbaja          , ';                    //18
                $sql = $sql.'usuario        , ';                    //19
                $sql = $sql.'fproceso       , ';                    //20
                $sql = $sql.'halta            ';                    //21
                $sql = $sql.') VALUES( ';
                $sql = $sql.':codigo         , ';                     //01
                $sql = $sql.':falta          , ';                     //02
                $sql = $sql.':fdesde         , ';                     //03
                $sql = $sql.':fhasta         , ';                     //04
                $sql = $sql.':cobertura      , ';                     //05
                $sql = $sql.':cliente        , ';                     //06
                $sql = $sql.':comercio       , ';                     //07
                $sql = $sql.':bien           , ';                     //08
                $sql = $sql.':vendedor       , ';                     //09
                $sql = $sql.':gfabrica       , ';                     //10
                $sql = $sql.':factura        , ';                     //11
                $sql = $sql.':fpago          , ';                     //12
                $sql = $sql.':referencia     , ';                     //13
                $sql = $sql.':capital        , ';                     //14
                $sql = $sql.':total          , ';                     //15
                $sql = $sql.':usuariob       , ';                     //16
                $sql = $sql.':fbaja          , ';                     //17
                $sql = $sql.':hbaja          , ';                     //18
                $sql = $sql.':usuario        , ';                     //19
                $sql = $sql.':fproceso       , ';                     //20
                $sql = $sql.':halta            ';                     //21
                $sql = $sql.') ';

            }else{

                $sql = $sql.'UPDATE garantia SET ';
                $sql = $sql.'falta           = :falta           , ';    //02
                $sql = $sql.'fdesde          = :fdesde          , ';    //03
                $sql = $sql.'fhasta          = :fhasta          , ';    //04
                $sql = $sql.'cobertura       = :cobertura       , ';    //05
                $sql = $sql.'cliente         = :cliente         , ';    //06
                $sql = $sql.'comercio        = :comercio        , ';    //07
                $sql = $sql.'bien            = :bien            , ';    //08
                $sql = $sql.'vendedor        = :vendedor        , ';    //09
                $sql = $sql.'gfabrica        = :gfabrica        , ';    //10
                $sql = $sql.'factura         = :factura         , ';    //11
                $sql = $sql.'fpago           = :fpago           , ';    //12
                $sql = $sql.'referencia      = :referencia      , ';    //13
                $sql = $sql.'capital         = :capital         , ';    //14
                $sql = $sql.'total           = :total           , ';    //15
                $sql = $sql.'usuariob        = :usuariob        , ';    //16
                $sql = $sql.'fbaja           = :fbaja           , ';    //17
                $sql = $sql.'hbaja           = :hbaja           , ';    //18
                $sql = $sql.'usuario         = :usuario         , ';    //19
                $sql = $sql.'fproceso        = :fproceso        , ';    //20
                $sql = $sql.'halta           = :halta            ';    //21
                $sql = $sql.'WHERE codigo = :codigo' ;        // 1

            }

            $dbh = $connection->prepare($sql);

            $dbh->bindParam(':codigo', $codigo);            //            01
            $dbh->bindParam(':falta', $falta);            //              02
            $dbh->bindParam(':fdesde', $fdesde);            //            03
            $dbh->bindParam(':fhasta', $fhasta);            //            04
            $dbh->bindParam(':cobertura', $cobertura);            //      05
            $dbh->bindParam(':cliente', $cliente);            //          06
            $dbh->bindParam(':comercio', $comercio);            //        07
            $dbh->bindParam(':bien', $bien);            //                08
            $dbh->bindParam(':vendedor', $vendedor);            //        09
            $dbh->bindParam(':gfabrica', $gfabrica);            //        10
            $dbh->bindParam(':factura', $factura);            //          11
            $dbh->bindParam(':fpago', $fpago);            //              12
            $dbh->bindParam(':referencia', $referencia);            //    13
            $dbh->bindParam(':capital', $capital);            //          14
            $dbh->bindParam(':total', $total);            //              15
            $dbh->bindParam(':usuariob', $usuariob);            //        16
            $dbh->bindParam(':fbaja', $fbaja);            //              17
            $dbh->bindParam(':hbaja', $hbaja);            //              18
            $dbh->bindParam(':usuario', $usuario);            //          19
            $dbh->bindParam(':fproceso', $fproceso);            //        20
            $dbh->bindParam(':halta', $halta);            //              21

            $dbh->execute();
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/garantia/:codigo',function($codigo) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('DELETE FROM garantia WHERE codigo = ?');
            $dbh->bindParam(1, $codigo);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
