<?php

if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/riesgo/:documento/:sexo/:concargo', function($documento,$sexo,$concargo) use($app)
{
    $ini = parse_ini_file('app/config/SET.ini');

    try{

        $connection = getConnection();
        $dbh = $connection->prepare('SELECT * '
                . 'FROM riesgo.camara '
                . 'WHERE numero = ? ');

        $dbh->bindParam(1, $documento);
        $dbh->execute();

        if ($dbh->rowCount()==0){

            $respuesta = array(
                array(
                    'documento'=>$documento,
                    'nombre'=>'',
                    'entidad'=>'NO REGISTRA DEUDA',
                    'fecha'=>date('Y-m-d'),
                    'empresa'=>'CAMARA',
                    'apto'=>'S'
                )
            );

        } else {

            $respuesta=array();

            $recordset = $dbh->fetch(PDO::FETCH_ASSOC);


            $ent1 =trim(substr( $recordset['EMPRE'],0,2));
            $ent2 =trim(substr( $recordset['EMPRE'],3,2));
            $ent3 =trim(substr( $recordset['EMPRE'],6,2));


            if ($ent1 <> '') {

                $dbh = $connection->prepare('SELECT * '
                        . 'FROM riesgo.entidad '
                        . 'WHERE codigo = ? ');

                $dbh->bindParam(1, $ent1);
                $dbh->execute();

                if ($dbh->rowCount()==0){

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$ent1,
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');

                } else {

                    $entidad = $dbh->fetch(PDO::FETCH_ASSOC);

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$entidad['NOMBRE'],
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');
                }

            }

            if ($ent2 <> '') {

                $dbh = $connection->prepare('SELECT * '
                        . 'FROM riesgo.entidad '
                        . 'WHERE codigo = ? ');

                $dbh->bindParam(1, $ent2);
                $dbh->execute();

                if ($dbh->rowCount()==0){

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$ent2,
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');

                } else {

                    $entidad = $dbh->fetch(PDO::FETCH_ASSOC);

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$entidad['NOMBRE'],
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');
                }

            }


            if ($ent3 <> '') {

                $dbh = $connection->prepare('SELECT * '
                        . 'FROM riesgo.entidad '
                        . 'WHERE codigo = ? ');

                $dbh->bindParam(1, $ent3);
                $dbh->execute();

                if ($dbh->rowCount()==0){

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$ent3,
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');

                } else {

                    $entidad = $dbh->fetch(PDO::FETCH_ASSOC);

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$entidad['NOMBRE'],
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');
                }

            }

        }

        if($concargo=='S'){
            if ($ini['CONSEVEN']=='S' ){

                $i=0;

                $xml = new DOMDocument();

                $nombrearchivo='app/informes/seven-'.$documento.date('Ymd').'.xml';
                if(file_exists($nombrearchivo)){
                    $xml->load($nombrearchivo);
                }  else {

                    try {
                        $wsdl_url = 'http://www.seven.com.ar/ws/clsinforme.asmx?wsdl';
                        $client = new SOAPClient($wsdl_url);
                        $params = array(
                            'Dni' => $documento,
                            'Sexo' => $sexo,
                            'IdAdherente' =>  $ini['ENTSEVEN'],
                            'IdSucursal' => $ini['SUCSEVEN'],
                            'Usuario' => $ini['USUSEVEN'],
                            'Password' => $ini['CLASEVEN'],
                        );
                        $return = $client->InformeDetalladoTabuladoPFisica($params);
                        $aresult = objectToArray($return);
                    } catch (Exception $e) {

                        $i++;
                        $respuesta[]= array(
                            'documento'=>$documento,
                            'nombre'=>'',
                            'entidad'=>"ERROR SEVEN ".$e->getMessage() ,
                            'fecha'=>date('Y-m-d') ,
                            'empresa'=>'SEVEN',
                            'apto'=>'N');

                    }

                    $xml->loadXML($aresult["InformeDetalladoTabuladoPFisicaResult"]);
                    $xml->save($nombrearchivo);

                }

                try{
                    $nombre = $xml->getElementsByTagName('ApellidoYNombres')->item(0)->nodeValue;
                } catch (Exception $ex) {
                    $nombre = '';
                }
                $nodos = $xml->getElementsByTagName('MorasVigentes');

                foreach($nodos as $nodo){

                    try {
                        $respuesta[]= array(
                            'documento'=>$documento,
                            'nombre'=>$nombre,
                            'entidad'=>$nodo->getElementsByTagName('RazonSocial')->item(0)->nodeValue,
                            'fecha'=>$nodo->getElementsByTagName('FechaIngreso')->item(0)->nodeValue,
                            'empresa'=>'SEVEN',
                            'apto'=>'N');
                        $i++;
                    } catch (Exception $ex) {

                    }

                }
                if ($i==0){
                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$nombre,
                        'entidad'=>"SEVEN OK",
                        'fecha'=>date('Y-m-d') ,
                        'empresa'=>'SEVEN',
                        'apto'=>'S');
                }

            }

            if ($ini['CONCODEME']=='S' ){

                $xml = new DOMDocument();
                $i=0;

                $nombrearchivo='app/informes/codeme-'.$documento.date('Ymd').'.xml';
                if(file_exists($nombrearchivo)){
                    $xml->load($nombrearchivo);
                }  else {

                    try {
                        $wsdl_url = '';
                        $wsdl_url = $wsdl_url . 'http://200.51.93.35/nevada/santotome.asp';
                        $wsdl_url = $wsdl_url . '?';
                        $wsdl_url = $wsdl_url . 'socio='.$ini['SOCCODEME'];
                        $wsdl_url = $wsdl_url . '&';
                        $wsdl_url = $wsdl_url . 'tipo=1';
                        $wsdl_url = $wsdl_url . '&';
                        $wsdl_url = $wsdl_url . 'documento=' . $documento;
                        $wsdl_url = $wsdl_url . '&';
                        $wsdl_url = $wsdl_url . 'clave='.$ini['CLACODEME'];

                        $curl = curl_init();
                        curl_setopt_array($curl, array(
                                                CURLOPT_RETURNTRANSFER => 1,
                                                CURLOPT_URL => $wsdl_url,
                                                CURLOPT_USERAGENT => 'Sigecre cURL Request'
                        ));

                        $resp = curl_exec($curl);
                        curl_close($curl);

                        $xml->loadXML($resp);
                        $xml->save($nombrearchivo);

                    } catch (Exception $ex) {
                        $i++;
                        $respuesta[]= array(
                            'documento'=>$documento,
                            'nombre'=>'',
                            'entidad'=>"ERROR CODEME ".$e->getMessage() ,
                            'fecha'=>date('Y-m-d') ,
                            'empresa'=>'CODEME',
                            'apto'=>'N');

                    }
                }

                try{
                    $nombre = $xml->getElementsByTagName('Nombre')->item(0)->nodeValue;
                    $cantidad = $xml->getElementsByTagName('Cantidad')->item(0)->nodeValue;
                } catch (Exception $ex) {
                    $nombre = '';
                    $cantidad = 0;
                }
                $nodos = $xml->getElementsByTagName('AA');


                foreach($nodos as $nodo){

                    try {
                        $respuesta[]= array(
                            'documento'=>$documento,
                            'nombre'=>$nombre,
                            'entidad'=>$nodo->getElementsByTagName('Nombre_Socio')->item(0)->nodeValue,
                            'fecha'=>$nodo->getElementsByTagName('Ingreso')->item(0)->nodeValue,
                            'empresa'=>'CODEME',
                            'apto'=>'N');
                        $i++;
                    } catch (Exception $ex) {

                    }

                }
                if ($i==0){
                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$nombre,
                        'entidad'=>"CODEME OK",
                        'fecha'=>date('Y-m-d') ,
                        'empresa'=>'CODEME',
                        'apto'=>'S');
                }
            }
        }

        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(my_json_encode($respuesta));

    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }

});


$app->get('/riesgoveraz/:dni/:sexo/:nombre', function($dni,$sexo,$nombre) use($app)
{

    $xml = new DOMDocument();

    $nombre = trim($nombre);

    $nombrearchivo='app/informes/equisfax-'.$dni.$sexo.strtoupper($nombre).date('Ymd').'.xml';
    if(file_exists($nombrearchivo)){
         $xml->load($nombrearchivo);
    }  else {


    	$VERMATRIZ="VN0379";
    	$VERUSUARIO="XML";
    	$VERPASS="64284132961259653714022561526";
    	$VERSECTOR="04";
    	$VERSUCU="0";

      $sTexto = "par_xml=";
    	$sTexto = $sTexto . "<?xml version='1.0' encoding='ISO-8859-1'?>";
    	$sTexto = $sTexto . "<mensaje>";
    	$sTexto = $sTexto . "<identificador>";
    	$sTexto = $sTexto . "    <userlogon>";
    	$sTexto = $sTexto . "        <matriz><![CDATA[$VERMATRIZ]]></matriz>";
    	$sTexto = $sTexto . "        <usuario><![CDATA[$VERUSUARIO]]></usuario>";
    	$sTexto = $sTexto . "        <password><![CDATA[$VERPASS]]> </password>";
    	$sTexto = $sTexto . "    </userlogon>";
    	$sTexto = $sTexto . "    <medio>completar medio</medio>";
    	$sTexto = $sTexto . "    <formatoInforme>H</formatoInforme>";
    	$sTexto = $sTexto . "    <reenvio/>";
    	$sTexto = $sTexto . "    <producto>RISC:Experto</producto>";
    	$sTexto = $sTexto . "    <lote>";
    	$sTexto = $sTexto . "        <sectorVeraz>$VERSECTOR</sectorVeraz>";
    	$sTexto = $sTexto . "        <sucursalVeraz>$VERSUCU</sucursalVeraz>";
    	$sTexto = $sTexto . "        <cliente>cliente</cliente>";
    	$sTexto = $sTexto . "        <fechaHora>2017-08-02T12:50:00.099</fechaHora>" ;
    	$sTexto = $sTexto . "    </lote>" ;
    	$sTexto = $sTexto . "</identificador>" ;
    	$sTexto = $sTexto . "<consulta>" ;
    	$sTexto = $sTexto . "    <integrantes>1</integrantes>" ;
    	$sTexto = $sTexto . "        <integrante valor='1'>" ;
    	$sTexto = $sTexto . "        <nombre><![CDATA[$nombre]]> </nombre>" ;
    	$sTexto = $sTexto . "        <sexo>$sexo</sexo>" ;
    	$sTexto = $sTexto . "        <documento><![CDATA[$dni]]> </documento>" ;
    	$sTexto = $sTexto . "    </integrante>" ;
    	$sTexto = $sTexto . "</consulta>" ;
    	$sTexto = $sTexto . "</mensaje>" ;

      $page = "https://online.org.veraz.com.ar/pls/consulta817/wserv";
      $headers = array(
            "POST ".$page." HTTP/1.0",
            "Content-type: text/xml;charset=\"utf-8\"",
            "Accept: text/xml",
            "Cache-Control: no-cache",
            "Pragma: no-cache",
            "SOAPAction: \"run\"",
            "Content-length: ".strlen($sTexto)
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $page);
        curl_setopt($ch, CURLOPT_POST, 1);// set post data to true
        //curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $sTexto);   // post data
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

        $result = curl_exec($ch);
        $error = curl_error($ch);
        curl_close ($ch);


        $xml->loadXML($result);
        $xml->save($nombrearchivo);
    }

    //var_dump($error);
    //$app->response->body($result);

    $app->response->headers->set('Content-type', 'application/xml');
    $app->response->status(200);
    $app->response->body( $xml->saveXML() );

});



$app->get('/listadoveraz', function() use($app)
{

    $path   = 'app/informes';
    $files  = scandir($path);
    $salida = [];

    $xml = new DOMDocument();

    foreach ($files as $file) {

        if($file=='.'){
        } elseif($file=='..'){
        } else {

            $fecha = date('Ymd',filectime($path.'/'.$file));

            $item = [];
            $item['archivo'] = $file;
            $item['fecha']   = $fecha;


            $salida[] = $item;
        }

    }

    $app->response->headers->set('Content-type', 'application/json');
    $app->response->status(200);
    $app->response->body(my_json_encode($salida));

});


$app->get('/archivoveraz/:archivo', function($archivo) use($app)
{

    $xml = new DOMDocument();
    $path   = 'app/informes';
    $nombrearchivo = $path.'/'.$archivo;

    if(file_exists($nombrearchivo)){
        $xml->load($nombrearchivo);
        $salida = $xml->saveXML();
    }
    else
    {
        $salida = "No existe Archivo $archivo";
    }

    $app->response->headers->set('Content-type', 'application/xml');
    $app->response->status(200);
    $app->response->body($salida);

});
