<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/rechazos/:cliente', function($cliente) use($app)
{

    $header = $app->request->getUserAgent();
    if (!verificarUsuario($header)){

        $app->response->headers->set('Content-type', 'text/plain');
        $app->response->status(401);
        $app->response->body('Usuario no autorizado');
    }
    else {
        
        try{
    
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT * FROM rechazos WHERE cliente = ?');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);
            $connection = null;
            
//            foreach($recordset as $registro ){
//                foreach($registro as $campo){
//                    $campo = \str_replace('º',' ',$campo);
//                    $campo = \str_replace('Ñ','N',$campo);
//                    echo $campo;
//                }
//            }
            $body = json_encode($recordset);

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body($body);

            
        } catch (Exception $ex) {
            echo 'Error en conexion: '.$ex->getMessage() ;
        }
    }        
    
});
        


