<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/observac/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $dbh = $connection->prepare('SELECT * FROM observac WHERE cliente = ?');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(my_json_encode($recordset));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});

        
$app->get('/observac/:cliente/:fecha/:hora', function($cliente,$fecha,$hora) use($app)
{
    try{
        
        $connection = getConnection();
        $dbh = $connection->prepare('SELECT * FROM observac WHERE cliente = ? and fecha = ? and hora = ?');
        $dbh->bindParam(1, $cliente);
        $dbh->bindParam(2, $fecha);
        $dbh->bindParam(3, $hora);
        $dbh->execute();
        $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);
        
        $connection = null;
        
        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(my_json_encode($recordset));
        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/observac/', function() use($app)
{

    $cliente        =        siNull($app->request->post('CLIENTE'),'');  //     01
    $campo          =        siNull($app->request->post('CAMPO'),'');  //       02
    $fecha          =        siNull($app->request->post('FECHA'),'');  //       03
    $hora           =        siNull($app->request->post('HORA'),'');  //        04
    $tipo           =        siNull($app->request->post('TIPO'),'');  //        05
        
    try{
        $connection = getConnection();
        $dbh = $connection->prepare('SELECT cliente FROM observac WHERE cliente = ? and fecha = ? and hora = ?');
        $dbh->bindParam(1, $cliente);
        $dbh->bindParam(2, $fecha);
        $dbh->bindParam(3, $hora);
        $dbh->execute();
        $recordcount = $dbh->rowCount();
        $sql = '';
        if($recordcount==0){
            
            $sql = $sql.'INSERT INTO observac ( ';
            $sql = $sql.'cliente        , ';                    //01
            $sql = $sql.'campo          , ';                    //02
            $sql = $sql.'fecha          , ';                    //03
            $sql = $sql.'hora           , ';                    //04
            $sql = $sql.'tipo             ';                    //05
            $sql = $sql.') VALUES( ';
            $sql = $sql.':cliente        , ';                     //01
            $sql = $sql.':campo          , ';                     //02
            $sql = $sql.':fecha          , ';                     //03
            $sql = $sql.':hora           , ';                     //04
            $sql = $sql.':tipo             ';                     //05
            $sql = $sql.') ';
            
        }else{

            $sql = $sql.'UPDATE observac SET ';
            $sql = $sql.'cliente         = :cliente         , ';    //01
            $sql = $sql.'campo           = :campo           , ';    //02
            $sql = $sql.'fecha           = :fecha           , ';    //03
            $sql = $sql.'hora            = :hora            , ';    //04
            $sql = $sql.'tipo            = :tipo              ';    //05
            $sql = $sql.'WHERE cliente = :cliente and fecha = :fecha and hora = :hora';        // 1

        }

        $dbh = $connection->prepare($sql);
        
        $dbh->bindParam(':cliente', $cliente);            //          01
        $dbh->bindParam(':campo', $campo);            //              02
        $dbh->bindParam(':fecha', $fecha);            //              03
        $dbh->bindParam(':hora', $hora);            //                04
        $dbh->bindParam(':tipo', $tipo);            //                05
        
        $dbh->execute();
        $connection = null;

        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(json_encode(array(array('estado'=>'OK'))));

        }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/observac/:cliente/:fecha/:hora',function($cliente,$fecha,$hora) use($app)
{
    try{
        
        $connection = getConnection();
        $dbh = $connection->prepare('DELETE FROM observac WHERE cliente = ?, fecha = ? , hora = ?');
        $dbh->bindParam(1, $clave);
        $dbh->bindParam(2, $fecha);
        $dbh->bindParam(3, $hora);
        $dbh->execute();

        $connection = null;
        
        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(json_encode(array(array('estado'=>'OK'))));
        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
