<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/', function() use($app){

   echo '<html>';
   echo '<head>';
   echo '<title>';
   echo 'Claves del Sistema';
   echo '</title>';
   echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
   echo '<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">';
   echo '</head>';
   echo '<body>';

   echo '<div class="container clearfix">';

   echo '<div class="jumbotron">';

   echo '<h3> ADC-Consultores</h3>';
   echo '<h5>Claves del Sistema </h5>';

   echo '<form action="/riesgo/consulta" method="post" >';
   echo '<div class="form-group" >';
   echo '<label for="DOCUMENTO" >Documento:</label>';
   echo '<input class="form-control" type "text" name="DOCUMENTO" id="DOCUMENTO" max="8" maxlength="8" size="6" autofocus  />  ';
   echo '</div>';
   echo '<input type="submit" value="Consultar" class="btn btn-primary" />';
   echo '</form>';

   echo '</div >';

   echo '</div >';
   echo '</body>';
   echo '</html>';

});

$app->post('/consulta', function() use($app)
{

    $documento = siNull($app->request->post('DOCUMENTO'),'');

    $documento = sprintf("%08d", intval($documento));

    date_default_timezone_set ( 'America/Argentina/Buenos_Aires' );

    $ini = parse_ini_file('app/config/SET.ini');

    try{

        $connection = getConnection();
        $connection->exec('set character set utf8');

        $dbh = $connection->prepare('SELECT * '
                . 'FROM camara '
                . 'WHERE numero = ? ');

        $dbh->bindParam(1, $documento);
        $dbh->execute();

        if ($dbh->rowCount()==0){

            $respuesta = array(
                array(
                    'documento'=>$documento,
                    'nombre'=>'',
                    'entidad'=>'NO REGISTRA DEUDA',
                    'fecha'=>date('Y-m-d'),
                    'empresa'=>'CAMARA',
                    'apto'=>'S'
                )
            );

        } else {

            $respuesta=array();

            $recordset = $dbh->fetch(PDO::FETCH_ASSOC);



            $ent1 = trim(substr( $recordset['EMPRE'],0,2));
            $ent2 = trim(substr( $recordset['EMPRE'],3,2));
            $ent3 = trim(substr( $recordset['EMPRE'],6,2));



            if ($ent1 <> '') {

                $dbh = $connection->prepare('SELECT * '
                        . 'FROM entidad '
                        . 'WHERE codigo = ? ');

                $dbh->bindParam(1, $ent1);
                $dbh->execute();

                if ($dbh->rowCount()==0){

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$ent1,
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');

                } else {

                    $entidad = $dbh->fetch(PDO::FETCH_ASSOC);

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$entidad['NOMBRE'],
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');
                }

            }

            if ($ent2 <> '') {

                $dbh = $connection->prepare('SELECT * '
                        . 'FROM entidad '
                        . 'WHERE codigo = ? ');

                $dbh->bindParam(1, $ent2);
                $dbh->execute();

                if ($dbh->rowCount()==0){

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$ent2,
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');

                } else {

                    $entidad = $dbh->fetch(PDO::FETCH_ASSOC);

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$entidad['NOMBRE'],
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');
                }

            }


            if ($ent3 <> '') {

                $dbh = $connection->prepare('SELECT * '
                        . 'FROM entidad '
                        . 'WHERE codigo = ? ');

                $dbh->bindParam(1, $ent3);
                $dbh->execute();

                if ($dbh->rowCount()==0){

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$ent3,
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');

                } else {

                    $entidad = $dbh->fetch(PDO::FETCH_ASSOC);

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$entidad['NOMBRE'],
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');
                }

            }

        }

        echo '<html>';
        echo '<head>';
        echo '<title>';
        echo 'Claves del Sistema';
        echo '</title>';
        echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
        echo '<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">';
        echo '</head>';
        echo '<body>';

        echo '<div class="container clearfix">';

        echo '<div class="jumbotron">';

        echo '<h3> ADC-Consultores</h3>';
        echo '<h5>Claves del Sistema </h5>';


        echo '<table class="table table-striped">';
        echo '  <tr>';
        echo '      <th>Documento</th>';
        echo '      <th>Nombre</th>';
        echo '      <th>Entidad</th>';
        echo '      <th>Fecha</th>';
        echo '      <th>Empresa</th>';
        echo '      <th>Apto</th>';
        echo '  </tr>';

        foreach ($respuesta as $registro){
            echo '  <tr>';

            foreach($registro as $clave=>$valor){
                echo '<td>';
                echo $valor;
                echo '</td>';
            }
            echo '  </tr>';

        }
        echo '</table>';

        echo '<br>';


        $anio = Date('Y');
        $mes = Date('m');
        $dia = Date('d');
        $hora = date('H');
        $c1 = substr($documento,-2);
        $c2 = ( ($c1*2)-2) % 100 ;
        $c7 = ( ($c1*7)-7) % 100 ;
        if($c7<0){
           $c7 = $c7+100;
        }
        if ($c2 < 0) $c2 = 0;
        $m = (($hora * 2) - 2) % 100;
        $m5 = (($hora * 5) - 5) % 100;

        $fechahora =  sprintf("%1$02d-%2$02d-%3$02d-%4$02d", $dia, $mes, $anio, $hora );

        $clave1 = darvuelta($dia.$hora.$mes );
        $clave2 = sprintf("%1$02d%2$02d%3$02d", (($dia * 2) - 2), (($hora * 2) - 2)  ,(($mes * 2) - 2)  );
        $clave3 = sprintf("%1$02d%2$02d%3$02d", (($dia * 2) - 2), $c2  ,$m );

        $clave4="";
        $diax3 = (($dia * 3) - 3) % 100 ;
        $clave4 = sprintf("%1$02d%2$02d%3$02d", $diax3, $c7  ,$m5 );

        echo '<table class="table table-bordered">';
        echo '  <tr>';
        echo '      <th>Tipo Clave</th>';
        echo '      <th>Valor</th>';
        echo '  </tr>';
        echo '  <tr>';
        echo '      <td>Fecha Actual</td>';
        echo '      <td>';
        echo        Date('d-m-Y H:i:s');
        echo '      </td>';
        echo '  </tr>';
        echo '  <tr>';
        echo '      <td>Clave 1</td>';
        echo '      <td>';
        echo        $clave1;
        echo '      </td>';
        echo '  </tr>';
        echo '  <tr>';
        echo '      <td>Clave 2</td>';
        echo '      <td>';
        echo        $clave2;
        echo '      </td>';
        echo '  </tr>';

        echo '  <tr>';
        echo '      <td>Clave 3</td>';
        echo '      <td>';
        echo        $clave3;
        echo '      </td>';
        echo '  </tr>';

        echo '  <tr>';
        echo '      <td>Clave C</td>';
        echo '      <td>';
        echo        $clave4;
        echo '      </td>';
        echo '  </tr>';

        echo '</table>';

        echo '<br>';

        echo '<a href="./" class="btn btn-primary" >Nueva Consulta</a>';

        echo '</div>';
        echo '</div>';
        echo '</body>';
        echo '</html>';




    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }

});

$app->get('/api/claves/:documento', function($documento) use($app){

   date_default_timezone_set ( 'America/Argentina/Buenos_Aires' );

   $anio = Date('Y');
   $mes = Date('m');
   $dia = Date('d');
   $hora = date('H');
   $c1 = substr($documento,-2);
   $c2 = ( ($c1*2)-2) % 100 ;
   $c7 = ( ($c1*7)-7) % 100 ;
   if($c7<0){
      $c7 = $c7+100;
   }
   if ($c2 < 0) $c2 = 0;
   $m = (($hora * 2) - 2) % 100;
   $m5 = (($hora * 5) - 5) % 100;

   $fechahora =  sprintf("%1$02d-%2$02d-%3$02d-%4$02d", $dia, $mes, $anio, $hora );

   $clave1 = darvuelta($dia.$hora.$mes );
   $clave2 = sprintf("%1$02d%2$02d%3$02d", (($dia * 2) - 2), (($hora * 2) - 2)  ,(($mes * 2) - 2)  );
   $clave3 = sprintf("%1$02d%2$02d%3$02d", (($dia * 2) - 2), $c2  ,$m );

   $clave4="";
   $diax3 = (($dia * 3) - 3) % 100 ;

   $clave4 = sprintf("%1$02d%2$02d%3$02d", $diax3, $c7  ,$m5 );


   $claves = [

       'clave1' => $clave1,
       'clave2' => $clave2,
       'clave3' => $clave3,
       'clave4' => $clave4,
       'fechahora' => $fechahora

   ];

   $app->response->headers->set('Content-type', 'application/json');
   $app->response->headers->set('Access-Control-Allow-Origin', '*');
   $app->response->headers->set('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization');
   $app->response->headers->set('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');
   $app->response->status(200);

   $app->response->body(json_encode( $claves ));


});

$app->get('/api/riesgo/:documento', function($documento) use($app)
{

    //$documento = siNull($app->request->post('DOCUMENTO'),'');

    $documento = sprintf("%08d", intval($documento));
    date_default_timezone_set ( 'America/Argentina/Buenos_Aires' );

    $ini = parse_ini_file('app/config/SET.ini');

    try{

        $connection = getConnection();
        $connection->exec('set character set utf8');

        $dbh = $connection->prepare('SELECT * '
                . 'FROM camara '
                . 'WHERE numero = ? ');

        $dbh->bindParam(1, $documento);
        $dbh->execute();

        if ($dbh->rowCount()==0){

            $respuesta = array(
                array(
                    'documento'=>$documento,
                    'nombre'=>'',
                    'entidad'=>'NO REGISTRA DEUDA',
                    'fecha'=>date('Y-m-d'),
                    'empresa'=>'CAMARA',
                    'apto'=>'S'
                )
            );

        } else {

            $respuesta=array();

            $recordset = $dbh->fetch(PDO::FETCH_ASSOC);

            $ent1 = trim(substr( $recordset['EMPRE'],0,2));
            $ent2 = trim(substr( $recordset['EMPRE'],3,2));
            $ent3 = trim(substr( $recordset['EMPRE'],6,2));

            if ($ent1 <> '') {

                $dbh = $connection->prepare('SELECT * '
                        . 'FROM entidad '
                        . 'WHERE codigo = ? ');

                $dbh->bindParam(1, $ent1);
                $dbh->execute();

                if ($dbh->rowCount()==0){

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$ent1,
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');

                } else {

                    $entidad = $dbh->fetch(PDO::FETCH_ASSOC);

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$entidad['NOMBRE'],
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');
                }

            }

            if ($ent2 <> '') {

                $dbh = $connection->prepare('SELECT * '
                        . 'FROM entidad '
                        . 'WHERE codigo = ? ');

                $dbh->bindParam(1, $ent2);
                $dbh->execute();

                if ($dbh->rowCount()==0){

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$ent2,
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');

                } else {

                    $entidad = $dbh->fetch(PDO::FETCH_ASSOC);

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$entidad['NOMBRE'],
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');
                }

            }


            if ($ent3 <> '') {

                $dbh = $connection->prepare('SELECT * '
                        . 'FROM entidad '
                        . 'WHERE codigo = ? ');

                $dbh->bindParam(1, $ent3);
                $dbh->execute();

                if ($dbh->rowCount()==0){

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$ent3,
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');

                } else {

                    $entidad = $dbh->fetch(PDO::FETCH_ASSOC);

                    $respuesta[]= array(
                        'documento'=>$documento,
                        'nombre'=>$recordset['NOMBRE'],
                        'entidad'=>$entidad['NOMBRE'],
                        'fecha'=>date('Y-m-d'),
                        'empresa'=>'CAMARA',
                        'apto'=>'N');
                }

            }

        }


        $app->response->headers->set('Content-type', 'application/json');
        $app->response->headers->set('Access-Control-Allow-Origin', '*');
        $app->response->headers->set('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization');
        $app->response->headers->set('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');

        $app->response->status(200);


        $app->response->body(json_encode( $respuesta ));


    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }

});
