<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/ajustes/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT aju.* '
                    . 'FROM ajustes aju, creditos cre '
                    . 'WHERE aju.prestam = cre.prestam '
                    . 'AND cre.cliente = ? ');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }    

    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/ajustes/', function() use($app)
{

    $codigo         =        siNull($app->request->post('CODIGO'),'');  //      01
    $prestam        =        siNull($app->request->post('PRESTAM'),'');  //     02
    $cliente        =        siNull($app->request->post('CLIENTE'),'');  //     03
    $comercio       =        siNull($app->request->post('COMERCIO'),'');  //    04
    $cuota          =        siNull($app->request->post('CUOTA'),'');  //       05
    $fecha          =        siNull($app->request->post('FECHA'),'');  //       06
    $importe        =        siNull($app->request->post('IMPORTE'),'');  //     07
    $recargo        =        siNull($app->request->post('RECARGO'),'');  //     08
    $bonific        =        siNull($app->request->post('BONIFIC'),'');  //     09
    $lote           =        siNull($app->request->post('LOTE'),'');  //        10
    $recorri        =        siNull($app->request->post('RECORRI'),'');  //     11
    $factura        =        siNull($app->request->post('FACTURA'),'');  //     12
    $tipfac         =        siNull($app->request->post('TIPFAC'),'');  //      13
    $fecproc        =        siNull($app->request->post('FECPROC'),'');  //     14
    $descuento      =        siNull($app->request->post('DESCUENTO'),'');  //   15
    $renovacion     =        siNull($app->request->post('RENOVACION'),'');  //  16
    $tipocance      =        siNull($app->request->post('TIPOCANCE'),'');  //   17
    $estacion       =        siNull($app->request->post('ESTACION'),'');  //    18
    $renovado       =        siNull($app->request->post('RENOVADO'),'');  //    19
    $refinan        =        siNull($app->request->post('REFINAN'),'');  //     20
    $cargesref      =        siNull($app->request->post('CARGESREF'),'');  //   21
    $cargespagu     =        siNull($app->request->post('CARGESPAGU'),'');  //  22
    $observac       =        siNull($app->request->post('OBSERVAC'),'');  //    23
    $netopun        =        siNull($app->request->post('NETOPUN'),'');  //     24
    $descpun        =        siNull($app->request->post('DESCPUN'),'');  //     25
    $carges         =        siNull($app->request->post('CARGES'),'');  //      26
    $netocge        =        siNull($app->request->post('NETOCGE'),'');  //     27
    $desccge        =        siNull($app->request->post('DESCCGE'),'');  //     28
    $autoriza       =        siNull($app->request->post('AUTORIZA'),'');  //    29
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('SELECT codigo, prestam, cuota '
                    . 'FROM ajustes '
                    . 'WHERE codigo = ? '
                    . 'AND prestam = ? '
                    . 'AND cuota = ? ');
            $dbh->bindParam(1, $codigo);
            $dbh->bindParam(2, $prestam);
            $dbh->bindParam(3, $cuota);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0){

                $sql = $sql.'INSERT INTO ajustes ( ';
                $sql = $sql.'codigo         , ';                    //01
                $sql = $sql.'prestam        , ';                    //02
                $sql = $sql.'cliente        , ';                    //03
                $sql = $sql.'comercio       , ';                    //04
                $sql = $sql.'cuota          , ';                    //05
                $sql = $sql.'fecha          , ';                    //06
                $sql = $sql.'importe        , ';                    //07
                $sql = $sql.'recargo        , ';                    //08
                $sql = $sql.'bonific        , ';                    //09
                $sql = $sql.'lote           , ';                    //10
                $sql = $sql.'recorri        , ';                    //11
                $sql = $sql.'factura        , ';                    //12
                $sql = $sql.'tipfac         , ';                    //13
                $sql = $sql.'fecproc        , ';                    //14
                $sql = $sql.'descuento      , ';                    //15
                $sql = $sql.'renovacion     , ';                    //16
                $sql = $sql.'tipocance      , ';                    //17
                $sql = $sql.'estacion       , ';                    //18
                $sql = $sql.'renovado       , ';                    //19
                $sql = $sql.'refinan        , ';                    //20
                $sql = $sql.'cargesref      , ';                    //21
                $sql = $sql.'cargespagu     , ';                    //22
                $sql = $sql.'observac       , ';                    //23
                $sql = $sql.'netopun        , ';                    //24
                $sql = $sql.'descpun        , ';                    //25
                $sql = $sql.'carges         , ';                    //26
                $sql = $sql.'netocge        , ';                    //27
                $sql = $sql.'desccge        , ';                    //28
                $sql = $sql.'autoriza         ';                    //29
                $sql = $sql.') VALUES( ';
                $sql = $sql.':codigo         , ';                     //01
                $sql = $sql.':prestam        , ';                     //02
                $sql = $sql.':cliente        , ';                     //03
                $sql = $sql.':comercio       , ';                     //04
                $sql = $sql.':cuota          , ';                     //05
                $sql = $sql.':fecha          , ';                     //06
                $sql = $sql.':importe        , ';                     //07
                $sql = $sql.':recargo        , ';                     //08
                $sql = $sql.':bonific        , ';                     //09
                $sql = $sql.':lote           , ';                     //10
                $sql = $sql.':recorri        , ';                     //11
                $sql = $sql.':factura        , ';                     //12
                $sql = $sql.':tipfac         , ';                     //13
                $sql = $sql.':fecproc        , ';                     //14
                $sql = $sql.':descuento      , ';                     //15
                $sql = $sql.':renovacion     , ';                     //16
                $sql = $sql.':tipocance      , ';                     //17
                $sql = $sql.':estacion       , ';                     //18
                $sql = $sql.':renovado       , ';                     //19
                $sql = $sql.':refinan        , ';                     //20
                $sql = $sql.':cargesref      , ';                     //21
                $sql = $sql.':cargespagu     , ';                     //22
                $sql = $sql.':observac       , ';                     //23
                $sql = $sql.':netopun        , ';                     //24
                $sql = $sql.':descpun        , ';                     //25
                $sql = $sql.':carges         , ';                     //26
                $sql = $sql.':netocge        , ';                     //27
                $sql = $sql.':desccge        , ';                     //28
                $sql = $sql.':autoriza         ';                     //29
                $sql = $sql.') ';

            }else{

                $sql = $sql.'UPDATE ajustes SET ';
                $sql = $sql.'cliente         = :cliente         , ';    //03
                $sql = $sql.'comercio        = :comercio        , ';    //04
                $sql = $sql.'fecha           = :fecha           , ';    //06
                $sql = $sql.'importe         = :importe         , ';    //07
                $sql = $sql.'recargo         = :recargo         , ';    //08
                $sql = $sql.'bonific         = :bonific         , ';    //09
                $sql = $sql.'lote            = :lote            , ';    //10
                $sql = $sql.'recorri         = :recorri         , ';    //11
                $sql = $sql.'factura         = :factura         , ';    //12
                $sql = $sql.'tipfac          = :tipfac          , ';    //13
                $sql = $sql.'fecproc         = :fecproc         , ';    //14
                $sql = $sql.'descuento       = :descuento       , ';    //15
                $sql = $sql.'renovacion      = :renovacion      , ';    //16
                $sql = $sql.'tipocance       = :tipocance       , ';    //17
                $sql = $sql.'estacion        = :estacion        , ';    //18
                $sql = $sql.'renovado        = :renovado        , ';    //19
                $sql = $sql.'refinan         = :refinan         , ';    //20
                $sql = $sql.'cargesref       = :cargesref       , ';    //21
                $sql = $sql.'cargespagu      = :cargespagu      , ';    //22
                $sql = $sql.'observac        = :observac        , ';    //23
                $sql = $sql.'netopun         = :netopun         , ';    //24
                $sql = $sql.'descpun         = :descpun         , ';    //25
                $sql = $sql.'carges          = :carges          , ';    //26
                $sql = $sql.'netocge         = :netocge         , ';    //27
                $sql = $sql.'desccge         = :desccge         , ';    //28
                $sql = $sql.'autoriza        = :autoriza         ';    //29
                $sql = $sql.'WHERE codigo = :codigo  '
                        . 'AND prestam = :prestam '
                        . 'AND cuota = :cuota ';        // 1

            }

            $dbh = $connection->prepare($sql);

            $dbh->bindParam(':codigo', $codigo);            //            01
            $dbh->bindParam(':prestam', $prestam);            //          02
            $dbh->bindParam(':cliente', $cliente);            //          03
            $dbh->bindParam(':comercio', $comercio);            //        04
            $dbh->bindParam(':cuota', $cuota);            //              05
            $dbh->bindParam(':fecha', $fecha);            //              06
            $dbh->bindParam(':importe', $importe);            //          07
            $dbh->bindParam(':recargo', $recargo);            //          08
            $dbh->bindParam(':bonific', $bonific);            //          09
            $dbh->bindParam(':lote', $lote);            //                10
            $dbh->bindParam(':recorri', $recorri);            //          11
            $dbh->bindParam(':factura', $factura);            //          12
            $dbh->bindParam(':tipfac', $tipfac);            //            13
            $dbh->bindParam(':fecproc', $fecproc);            //          14
            $dbh->bindParam(':descuento', $descuento);            //      15
            $dbh->bindParam(':renovacion', $renovacion);            //    16
            $dbh->bindParam(':tipocance', $tipocance);            //      17
            $dbh->bindParam(':estacion', $estacion);            //        18
            $dbh->bindParam(':renovado', $renovado);            //        19
            $dbh->bindParam(':refinan', $refinan);            //          20
            $dbh->bindParam(':cargesref', $cargesref);            //      21
            $dbh->bindParam(':cargespagu', $cargespagu);            //    22
            $dbh->bindParam(':observac', $observac);            //        23
            $dbh->bindParam(':netopun', $netopun);            //          24
            $dbh->bindParam(':descpun', $descpun);            //          25
            $dbh->bindParam(':carges', $carges);            //            26
            $dbh->bindParam(':netocge', $netocge);            //          27
            $dbh->bindParam(':desccge', $desccge);            //          28
            $dbh->bindParam(':autoriza', $autoriza);            //        29

            $dbh->execute();
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
        }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/ajustes/:codigo/:prestam/:cuota',function($codigo,$prestam,$cuota) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('DELETE FROM ajustes '
                    . 'WHERE codigo = ? '
                    . 'AND prestam = ? '
                    . 'AND cuota = ? ');
            $dbh->bindParam(1, $codigo);
            $dbh->bindParam(2, $prestam);
            $dbh->bindParam(3, $cuota);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
            
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
