<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/clieauto/:numero', function($numero) use($app)
{
    try{
        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT * FROM clieauto WHERE numero = ?');
            $dbh->bindParam(1, $numero);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/clieauto/', function() use($app)
{

    $numero         =        siNull($app->request->post('NUMERO'),'');  //      01
    $titular        =        siNull($app->request->post('TITULAR'),'');  //     02
    $vinculo        =        siNull($app->request->post('VINCULO'),'');  //     03
    $fecha          =        siNull($app->request->post('FECHA'),'');  //       04
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('SELECT numero FROM clieauto '
                    . 'WHERE numero = ? '
                    . 'AND titular = ? ');
            $dbh->bindParam(1, $numero);
            $dbh->bindParam(2, $titular);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0){

                $sql = $sql.'INSERT INTO clieauto ( ';
                $sql = $sql.'numero         , ';                    //01
                $sql = $sql.'titular        , ';                    //02
                $sql = $sql.'vinculo        , ';                    //03
                $sql = $sql.'fecha            ';                    //04
                $sql = $sql.') VALUES( ';
                $sql = $sql.':numero         , ';                     //01
                $sql = $sql.':titular        , ';                     //02
                $sql = $sql.':vinculo        , ';                     //03
                $sql = $sql.':fecha            ';                     //04
                $sql = $sql.') ';

            }else{

                $sql = $sql.'UPDATE clieauto SET ';
                $sql = $sql.'vinculo         = :vinculo         , ';    //03
                $sql = $sql.'fecha           = :fecha            ';    //04
                $sql = $sql.'WHERE numero = :numero '
                        . 'AND titular = :titular ';        // 1

            }

            $dbh = $connection->prepare($sql);

            $dbh->bindParam(':numero', $numero);            //            01
            $dbh->bindParam(':titular', $titular);            //          02
            $dbh->bindParam(':vinculo', $vinculo);            //          03
            $dbh->bindParam(':fecha', $fecha);            //              04

            $dbh->execute();
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/clieauto/:numero/:titular',function($numero,$titular) use($app)
{
    try{
        
        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('DELETE FROM clieauto '
                    . 'WHERE numero = ? '
                    . 'AND titular = ? ');
            $dbh->bindParam(1, $numero);
            $dbh->bindParam(2, $titular);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
