<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/planes/:codigo', function($codigo) use($app)
{
   try{

      $header = $app->request->getUserAgent();
      if (!verificarUsuario($header)){

         $app->response->headers->set('Content-type', 'text/plain');
         $app->response->status(401);
         $app->response->body('Usuario no autorizado');
      }
      else {

         $connection = getConnection();
         $connection->exec('set character set utf8');

         $dbh = $connection->prepare('SELECT * FROM planes WHERE codigo = ?');
         $dbh->bindParam(1, $codigo);
         $dbh->execute();
         $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

         $connection = null;

         $app->response->headers->set('Content-type', 'application/json');
         $app->response->status(200);
         $app->response->body(json_encode($recordset));
      }
   } catch (PDOException $ex) {
      echo 'Error en conexion: '.$ex->getMessage() ;
   }

});

$app->post('/planes/', function() use($app)
{
   $codigo         =        siNull($app->request->post('CODIGO'),'');
   $descrip        =        siNull($app->request->post('DESCRIP'),'');
   $koefic         =        siNull($app->request->post('KOEFIC'),'');
   $cancuo         =        siNull($app->request->post('CANCUO'),'');
   $porinte        =        siNull($app->request->post('PORINTE'),'');
   $plazo          =        siNull($app->request->post('PLAZO'),'');
   $porgas         =        siNull($app->request->post('PORGAS'),'');
   $adeven         =        siNull($app->request->post('ADEVEN'),'');
   $percuo         =        siNull($app->request->post('PERCUO'),'');
   $retcuo         =        siNull($app->request->post('RETCUO'),'');
   $porcom         =        siNull($app->request->post('PORCOM'),'');
   $moneda         =        siNull($app->request->post('MONEDA'),'');
   $indajus        =        siNull($app->request->post('INDAJUS'),'');
   $calcven        =        siNull($app->request->post('CALCVEN'),'');
   $cuobon         =        siNull($app->request->post('CUOBON'),'');
   $cuobon2        =        siNull($app->request->post('CUOBON2'),'');
   $tipo           =        siNull($app->request->post('TIPO'),'');
   $categoria      =        siNull($app->request->post('CATEGORIA'),'');
   $cantcancel     =        siNull($app->request->post('CANTCANCEL'),'');
   $anticipo       =        siNull($app->request->post('ANTICIPO'),'');
   $codigoant      =        siNull($app->request->post('CODIGOANT'),'');
   $sinpun         =        siNull($app->request->post('SINPUN'),'');
   $grupoplan      =        siNull($app->request->post('GRUPOPLAN'),'');
   $cancancela     =        siNull($app->request->post('CANCANCELA'),'');
   $grupo          =        siNull($app->request->post('GRUPO'),'');
   $nocupo         =        siNull($app->request->post('NOCUPO'),'');
   $hastacanc      =        siNull($app->request->post('HASTACANC'),'');
   $porgasfin      =        siNull($app->request->post('PORGASFIN'),'');
   $maxvto         =        siNull($app->request->post('MAXVTO'),'');
   $descpun        =        siNull($app->request->post('DESCPUN'),'');
   $porcpromo      =        siNull($app->request->post('PORCPROMO'),'');
   $promodesc      =        siNull($app->request->post('PROMODESC'),'');
	
	$pdesccuota =  		siNull($app->request->post('PDESCCUOTA'),'');
   $dias_prm       =        siNull($app->request->post('DIAS_PRM'),'');
   $desc_prm       =        siNull($app->request->post('DESC_PRM'),'');
   $regalo            =        siNull($app->request->post('REGALO'),'');


   try{

      $header = $app->request->getUserAgent();
      if (!verificarUsuario($header)){

         $app->response->headers->set('Content-type', 'text/plain');
         $app->response->status(401);
         $app->response->body('Usuario no autorizado');
      }
      else {

         $connection = getConnection();
         $connection->exec('set character set utf8');

         $dbh = $connection->prepare('SELECT codigo FROM planes WHERE codigo = ?');
         $dbh->bindParam(1, $codigo);
         $dbh->execute();
         $recordcount = $dbh->rowCount();
         $sql = '';
         if($recordcount==0){

            $sql = $sql.'INSERT INTO planes ( ';
            $sql = $sql.'codigo          , ';
            $sql = $sql.'descrip         , ';
            $sql = $sql.'koefic          , ';
            $sql = $sql.'cancuo          , ';
            $sql = $sql.'porinte         , ';
            $sql = $sql.'plazo         , ';
            $sql = $sql.'porgas         , ';
            $sql = $sql.'adeven         , ';
            $sql = $sql.'percuo         , ';
            $sql = $sql.'retcuo         , ';
            $sql = $sql.'porcom         , ';
            $sql = $sql.'moneda         , ';
            $sql = $sql.'indajus         , ';
            $sql = $sql.'calcven         , ';
            $sql = $sql.'cuobon         , ';
            $sql = $sql.'cuobon2        , ';
            $sql = $sql.'tipo           , ';
            $sql = $sql.'categoria     , ';
            $sql = $sql.'cantcancel     , ';
            $sql = $sql.'anticipo     , ';
            $sql = $sql.'codigoant     , ';
            $sql = $sql.'sinpun     , ';
            $sql = $sql.'grupoplan     , ';
            $sql = $sql.'cancancela     , ';
            $sql = $sql.'grupo     , ';
            $sql = $sql.'nocupo     , ';
            $sql = $sql.'hastacanc     , ';
            $sql = $sql.'porgasfin     , ';
            $sql = $sql.'maxvto     , ';
            $sql = $sql.'descpun     , ';
            $sql = $sql.'promodesc   , ';
            $sql = $sql.'pdesccuota  , ';
            $sql = $sql.'dias_prm   , ';
            $sql = $sql.'desc_prm   , ';
            $sql = $sql.'regalo   , ';
            $sql = $sql.'porcpromo        ';
            $sql = $sql.') VALUES( ';
            $sql = $sql.':codigo          , ';
            $sql = $sql.':descrip         , ';
            $sql = $sql.':koefic          , ';
            $sql = $sql.':cancuo          , ';
            $sql = $sql.':porinte         , ';
            $sql = $sql.':plazo         , ';
            $sql = $sql.':porgas         , ';
            $sql = $sql.':adeven         , ';
            $sql = $sql.':percuo         , ';
            $sql = $sql.':retcuo         , ';
            $sql = $sql.':porcom         , ';
            $sql = $sql.':moneda         , ';
            $sql = $sql.':indajus         , ';
            $sql = $sql.':calcven         , ';
            $sql = $sql.':cuobon         , ';
            $sql = $sql.':cuobon2        , ';
            $sql = $sql.':tipo           , ';
            $sql = $sql.':categoria     , ';
            $sql = $sql.':cantcancel     , ';
            $sql = $sql.':anticipo     , ';
            $sql = $sql.':codigoant     , ';
            $sql = $sql.':sinpun     , ';
            $sql = $sql.':grupoplan     , ';
            $sql = $sql.':cancancela     , ';
            $sql = $sql.':grupo     , ';
            $sql = $sql.':nocupo     , ';
            $sql = $sql.':hastacanc     , ';
            $sql = $sql.':porgasfin     , ';
            $sql = $sql.':maxvto     , ';
            $sql = $sql.':descpun     , ';
            $sql = $sql.':promodesc     , ';
            $sql = $sql.':pdesccuota    , ';
            $sql = $sql.':dias_prm     , ';
            $sql = $sql.':desc_prm     , ';
            $sql = $sql.':regalo     , ';
            $sql = $sql.':porcpromo        ';
            $sql = $sql.') ';

         }else{

            $sql = $sql.'UPDATE planes SET ';
            $sql = $sql.'descrip         = :descrip         , ';
            $sql = $sql.'koefic          = :koefic           , ';
            $sql = $sql.'cancuo          = :cancuo           , ';
            $sql = $sql.'porinte         = :porinte           , ';
            $sql = $sql.'plazo           = :plazo           , ';
            $sql = $sql.'porgas          = :porgas           , ';
            $sql = $sql.'adeven          = :adeven           , ';
            $sql = $sql.'percuo          = :percuo           , ';
            $sql = $sql.'retcuo          = :retcuo           , ';
            $sql = $sql.'porcom          = :porcom           , ';
            $sql = $sql.'moneda          = :moneda           , ';
            $sql = $sql.'indajus         = :indajus           , ';
            $sql = $sql.'calcven         = :calcven           , ';
            $sql = $sql.'cuobon          = :cuobon           , ';
            $sql = $sql.'cuobon2         = :cuobon2           , ';
            $sql = $sql.'tipo            = :tipo           , ';
            $sql = $sql.'categoria       = :categoria           , ';
            $sql = $sql.'cantcancel      = :cantcancel           , ';
            $sql = $sql.'anticipo        = :anticipo           , ';
            $sql = $sql.'codigoant       = :codigoant           , ';
            $sql = $sql.'sinpun          = :sinpun           , ';
            $sql = $sql.'grupoplan       = :grupoplan           , ';
            $sql = $sql.'cancancela      = :cancancela           , ';
            $sql = $sql.'grupo           = :grupo           , ';
            $sql = $sql.'nocupo          = :nocupo           , ';
            $sql = $sql.'hastacanc       = :hastacanc           , ';
            $sql = $sql.'porgasfin       = :porgasfin           , ';
            $sql = $sql.'maxvto          = :maxvto           , ';
            $sql = $sql.'descpun         = :descpun           , ';
            $sql = $sql.'promodesc       = :promodesc           , ';
            $sql = $sql.'pdesccuota       = :pdesccuota           , ';
            $sql = $sql.'dias_prm        = :dias_prm           , ';
            $sql = $sql.'desc_prm        = :desc_prm           , ';
            $sql = $sql.'regalo               = :regalo           , ';
            $sql = $sql.'porcpromo      = :porcpromo       ';
            $sql = $sql.'WHERE codigo   = :codigo';
         }

         $dbh = $connection->prepare($sql);

         $dbh->bindParam(':codigo', $codigo);
         $dbh->bindParam(':descrip', $descrip);
         $dbh->bindParam(':koefic', $koefic);
         $dbh->bindParam(':cancuo', $cancuo);
         $dbh->bindParam(':porinte', $porinte);
         $dbh->bindParam(':plazo', $plazo);
         $dbh->bindParam(':porgas', $porgas);
         $dbh->bindParam(':adeven', $adeven);
         $dbh->bindParam(':percuo', $percuo);
         $dbh->bindParam(':retcuo', $retcuo);
         $dbh->bindParam(':porcom', $porcom);
         $dbh->bindParam(':moneda', $moneda);
         $dbh->bindParam(':indajus', $indajus);
         $dbh->bindParam(':calcven', $calcven);
         $dbh->bindParam(':cuobon', $cuobon);
         $dbh->bindParam(':cuobon2', $cuobon2);
         $dbh->bindParam(':tipo', $tipo);
         $dbh->bindParam(':categoria', $categoria);
         $dbh->bindParam(':cantcancel', $cantcancel);
         $dbh->bindParam(':anticipo', $anticipo);
         $dbh->bindParam(':codigoant', $codigoant);
         $dbh->bindParam(':sinpun', $sinpun);
         $dbh->bindParam(':grupoplan', $grupoplan);
         $dbh->bindParam(':cancancela', $cancancela);
         $dbh->bindParam(':grupo', $grupo);
         $dbh->bindParam(':nocupo', $nocupo);
         $dbh->bindParam(':hastacanc', $hastacanc);
         $dbh->bindParam(':porgasfin', $porgasfin);
         $dbh->bindParam(':maxvto', $maxvto);
         $dbh->bindParam(':maxvto', $maxvto);
         $dbh->bindParam(':descpun', $descpun);
         $dbh->bindParam(':porcpromo', $porcpromo);
         $dbh->bindParam(':promodesc', $promodesc);
         $dbh->bindParam(':pdesccuota', $pdesccuota);

         $dbh->bindParam(':dias_prm', $dias_prm);
         $dbh->bindParam(':desc_prm', $desc_prm);
         $dbh->bindParam(':regalo', $regalo);

         $dbh->execute();
         $connection = null;

         $app->response->headers->set('Content-type', 'application/json');
         $app->response->status(200);
         $app->response->body(json_encode(array(array('estado'=>'OK'))));
      }
   }catch(PDOException $e) {
      echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/planes/:codigo',function($codigo) use($app)
{
   try{

      $header = $app->request->getUserAgent();
      if (!verificarUsuario($header)){

         $app->response->headers->set('Content-type', 'text/plain');
         $app->response->status(401);
         $app->response->body('Usuario no autorizado');
      }
      else {

         $connection = getConnection();
         $connection->exec('set character set utf8');
         $dbh = $connection->prepare('DELETE FROM planes WHERE codigo = ?');
         $dbh->bindParam(1, $codigo);
         $dbh->execute();

         $connection = null;

         $app->response->headers->set('Content-type', 'application/json');
         $app->response->status(200);
         $app->response->body(json_encode(array(array('estado'=>'OK'))));
      }
   } catch (PDOException $ex) {
      echo 'Error en conexion: '.$ex->getMessage() ;
   }
});
