<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/pidedato/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

            $connection = getConnection();
            $connection->exec('set character set utf8');

            $dbh = $connection->prepare('SELECT * '
                    . 'FROM pidedato '
                    . 'WHERE cliente = ?');

            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }

});

$app->post('/pidedato/', function() use($app)
{

   $codigo         =        siNull($app->request->post('CODIGO'),'');  //     01
   $cliente        =        siNull($app->request->post('CLIENTE'),'');  //    02
   $fecha          =        siNull($app->request->post('FECHA'),'');  //      03
   $hora           =        siNull($app->request->post('HORA'),'');  //       04
   $operador       =        siNull($app->request->post('OPERADOR'),'');  //   05
   $observac       =        siNull($app->request->post('OBSERVAC'),'');  //   06
   $comercio       =        siNull($app->request->post('COMERCIO'),'');  //   07
   $cfecha         =        siNull($app->request->post('CFECHA'),'');  //     08
   $chora          =        siNull($app->request->post('CHORA'),'');  //      09
   $coperador      =        siNull($app->request->post('COPERADOR'),'');  //  10
   $afecha         =        siNull($app->request->post('AFECHA'),'');  //     11
   $ahora          =        siNull($app->request->post('AHORA'),'');  //      12
   $aoperador      =        siNull($app->request->post('AOPERADOR'),'');  //  13

   try{

      $header = $app->request->getUserAgent();
      if (!verificarUsuario($header)){

         $app->response->headers->set('Content-type', 'text/plain');
         $app->response->status(401);
         $app->response->body('Usuario no autorizado');

      } else {

            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('SELECT codigo '
                    . 'FROM pidedato '
                    . 'WHERE codigo = ? ');

            $dbh->bindParam(1, $codigo);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0){

                $sql = $sql.'INSERT INTO pidedato ( ';
                $sql = $sql.'codigo        , ';                    //01
                $sql = $sql.'cliente       , ';                    //02
                $sql = $sql.'fecha         , ';                    //03
                $sql = $sql.'hora          , ';                    //04
                $sql = $sql.'operador      , ';                    //05
                $sql = $sql.'observac      , ';                    //06
                $sql = $sql.'comercio      , ';                    //07
                $sql = $sql.'cfecha        , ';                    //08
                $sql = $sql.'chora         , ';                    //09
                $sql = $sql.'coperador     , ';                    //10
                $sql = $sql.'afecha        , ';                    //11
                $sql = $sql.'ahora         , ';                    //12
                $sql = $sql.'aoperador       ';                    //13
                $sql = $sql.') VALUES( ';
                $sql = $sql.':codigo       , ';                    //01
                $sql = $sql.':cliente      , ';                    //02
                $sql = $sql.':fecha        , ';                    //03
                $sql = $sql.':hora         , ';                    //04
                $sql = $sql.':operador     , ';                    //05
                $sql = $sql.':observac     , ';                    //06
                $sql = $sql.':comercio     , ';                    //07
                $sql = $sql.':cfecha       , ';                    //08
                $sql = $sql.':chora        , ';                    //09
                $sql = $sql.':coperador    , ';                    //10
                $sql = $sql.':afecha       , ';                    //11
                $sql = $sql.':ahora        , ';                    //12
                $sql = $sql.':aoperador      ';                    //13
                $sql = $sql.') ';

            }else{

                $sql = $sql.'UPDATE pidedato SET ';
                $sql = $sql.'cliente         = :cliente          , ';    //02
                $sql = $sql.'fecha           = :fecha            , ';    //03
                $sql = $sql.'hora            = :hora             , ';    //04
                $sql = $sql.'operador        = :operador         , ';    //05
                $sql = $sql.'observac        = :observac         , ';    //06
                $sql = $sql.'comercio        = :comercio         , ';    //07
                $sql = $sql.'cfecha          = :cfecha           , ';    //08
                $sql = $sql.'chora           = :chora            , ';    //09
                $sql = $sql.'coperador       = :coperador        , ';    //10
                $sql = $sql.'afecha          = :afecha           , ';    //11
                $sql = $sql.'ahora           = :ahora            , ';    //12
                $sql = $sql.'aoperador       = :aoperador          ';    //13
                $sql = $sql.'WHERE codigo = :codigo ';

            }

            $dbh = $connection->prepare($sql);

            $dbh->bindParam(':codigo', $codigo);                  //          01
            $dbh->bindParam(':cliente', $cliente);                //          02
            $dbh->bindParam(':fecha', $fecha);                    //          03
            $dbh->bindParam(':hora', $hora);                      //          04
            $dbh->bindParam(':operador', $operador);              //          05
            $dbh->bindParam(':observac', $observac);              //          06
            $dbh->bindParam(':comercio', $comercio);              //          07
            $dbh->bindParam(':cfecha', $cfecha);                  //          08
            $dbh->bindParam(':chora', $chora);                    //          09
            $dbh->bindParam(':coperador', $coperador);            //          10
            $dbh->bindParam(':afecha', $afecha);                  //          11
            $dbh->bindParam(':ahora', $ahora);                    //          12
            $dbh->bindParam(':aoperador', $aoperador);            //          13

            $dbh->execute();
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    }
    catch(PDOException $e)
    {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/pidedato/:codigo',function($codigo) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('DELETE FROM pidedato '
                    . 'WHERE hora = ? ');

            $dbh->bindParam(1, $codigo);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
