<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/gestion/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT ges.* '
                    . 'FROM gestion ges, creditos cre '
                    . 'WHERE ges.credito = cre.prestam '
                    . 'AND cre.cliente = ?');

            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/gestion/', function() use($app)
{

    $credito        =        siNull($app->request->post('CREDITO'),'');  //     01
    $envio          =        siNull($app->request->post('ENVIO'),'');  //       02
    $fecha          =        siNull($app->request->post('FECHA'),'');  //       03
    $hora           =        siNull($app->request->post('HORA'),'');  //        04
    $evento         =        siNull($app->request->post('EVENTO'),'');  //      05
    $descri         =        siNull($app->request->post('DESCRI'),'');  //      06
    $usuario        =        siNull($app->request->post('USUARIO'),'');  //     07
    $promesa        =        siNull($app->request->post('PROMESA'),'');  //     08
    $descri2        =        siNull($app->request->post('DESCRI2'),'');  //     09
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('SELECT credito '
                    . 'FROM gestion '
                    . 'WHERE credito = ? '
                    . 'AND envio = ? '
                    . 'AND fecha = ? '
                    . 'AND hora = ? ');
            $dbh->bindParam(1, $credito);
            $dbh->bindParam(2, $envio);
            $dbh->bindParam(3, $fecha);
            $dbh->bindParam(4, $hora);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0){

                $sql = $sql.'INSERT INTO gestion ( ';
                $sql = $sql.'credito        , ';                    //01
                $sql = $sql.'envio          , ';                    //02
                $sql = $sql.'fecha          , ';                    //03
                $sql = $sql.'hora           , ';                    //04
                $sql = $sql.'evento         , ';                    //05
                $sql = $sql.'descri         , ';                    //06
                $sql = $sql.'usuario        , ';                    //07
                $sql = $sql.'promesa        , ';                    //08
                $sql = $sql.'descri2          ';                    //09
                $sql = $sql.') VALUES( ';
                $sql = $sql.':credito        , ';                     //01
                $sql = $sql.':envio          , ';                     //02
                $sql = $sql.':fecha          , ';                     //03
                $sql = $sql.':hora           , ';                     //04
                $sql = $sql.':evento         , ';                     //05
                $sql = $sql.':descri         , ';                     //06
                $sql = $sql.':usuario        , ';                     //07
                $sql = $sql.':promesa        , ';                     //08
                $sql = $sql.':descri2          ';                     //08
                $sql = $sql.') ';

            }else{

                $sql = $sql.'UPDATE gestion SET ';
                $sql = $sql.'evento          = :evento          , ';    //05
                $sql = $sql.'descri          = :descri          , ';    //06
                $sql = $sql.'usuario         = :usuario         , ';    //07
                $sql = $sql.'promesa         = :promesa         , ';    //08
                $sql = $sql.'descri2         = :descri2           ';    //09
                
                $sql = $sql.'WHERE credito = :credito '
                        . 'AND envio = :envio '
                        . 'AND fecha = :fecha '
                        . 'AND hora = :hora ' ;        // 1

            }

            $dbh = $connection->prepare($sql);

            $dbh->bindParam(':credito', $credito);            //          01
            $dbh->bindParam(':envio', $envio);            //              02
            $dbh->bindParam(':fecha', $fecha);            //              03
            $dbh->bindParam(':hora', $hora);            //                04
            $dbh->bindParam(':evento', $evento);            //            05
            $dbh->bindParam(':descri', $descri);            //            06
            $dbh->bindParam(':usuario', $usuario);            //          07
            $dbh->bindParam(':promesa', $promesa);            //          08
            $dbh->bindParam(':descri2', $descri2);            //          09

            $dbh->execute();
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    }
    catch(PDOException $e)
    {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/gestion/:credito/:envio/:fecha/:hora',function($credito,$envio,$fecha,$hora) use($app)
{
    try{
        
        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('DELETE FROM gestion '
                    . 'WHERE credito = ? '
                    . 'AND envio = ? '
                    . 'AND fecha = ? '
                    . 'AND hora = ? ');

            $dbh->bindParam(1, $credito);
            $dbh->bindParam(2, $envio);
            $dbh->bindParam(3, $fecha);
            $dbh->bindParam(4, $hora);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
