<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/creditos/:cliente', function($cliente) use($app)
{

    $header = $app->request->getUserAgent();
    if (!verificarUsuario($header)){

        $app->response->headers->set('Content-type', 'text/plain');
        $app->response->status(401);
        $app->response->body('Usuario no autorizado');
    }
    else {

        try{

            $connection = getConnection();
            $connection->exec('set character set utf8');

            $dbh = $connection->prepare('SELECT * FROM creditos WHERE cliente = ?');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);
            $connection = null;

            $body = json_encode($recordset);

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body($body);


        } catch (Exception $ex) {
            echo 'Error en conexion: '.$ex->getMessage() ;
        }
    }

});



$app->post('/creditos/', function() use($app)
{
    $prestam        =        siNull($app->request->post('PRESTAM'),'');  //     01
    $cliente        =        siNull($app->request->post('CLIENTE'),'');  //     02
    $lote           =        siNull($app->request->post('LOTE'),'');  //        03
    $plan           =        siNull($app->request->post('PLAN'),'');  //        04
    $feclot         =        siNull($app->request->post('FECLOT'),'');  //      05
    $comercio       =        siNull($app->request->post('COMERCIO'),'');  //    06
    $fecha          =        siNull($app->request->post('FECHA'),'');  //       07
    $capital        =        siNull($app->request->post('CAPITAL'),'');  //     08
    $gastos         =        siNull($app->request->post('GASTOS'),'');  //      09
    $comision       =        siNull($app->request->post('COMISION'),'');  //    10
    $pricuot        =        siNull($app->request->post('PRICUOT'),'');  //     11
    $cancuot        =        siNull($app->request->post('CANCUOT'),'');  //     12
    $ultcuot        =        siNull($app->request->post('ULTCUOT'),'');  //     13
    $impcuot        =        siNull($app->request->post('IMPCUOT'),'');  //     14
    $ajustado       =        siNull($app->request->post('AJUSTADO'),'');  //    15
    $juicio         =        siNull($app->request->post('JUICIO'),'');  //      16
    $factura        =        siNull($app->request->post('FACTURA'),'');  //     17
    $tipfac         =        siNull($app->request->post('TIPFAC'),'');  //      18
    $impocup        =        siNull($app->request->post('IMPOCUP'),'');  //     19
    $recorri        =        siNull($app->request->post('RECORRI'),'');  //     20
    $codvie         =        siNull($app->request->post('CODVIE'),'');  //      21
    $gastoven       =        siNull($app->request->post('GASTOVEN'),'');  //    22
    $fecprivenc     =        siNull($app->request->post('FECPRIVENC'),'');  //  23
    $cappagado      =        siNull($app->request->post('CAPPAGADO'),'');  //   24
    $adelanref      =        siNull($app->request->post('ADELANREF'),'');  //   25
    $observac       =        siNull($app->request->post('OBSERVAC'),'');  //    26
    $cargesref      =        siNull($app->request->post('CARGESREF'),'');  //   27
    $cobcuoade      =        siNull($app->request->post('COBCUOADE'),'');  //   28
    $cobgastos      =        siNull($app->request->post('COBGASTOS'),'');  //   29
    $ordpago        =        siNull($app->request->post('ORDPAGO'),'');  //     30
    $fecpago        =        siNull($app->request->post('FECPAGO'),'');  //     31
    $caida          =        siNull($app->request->post('CAIDA'),'');  //       32
    $estado         =        siNull($app->request->post('ESTADO'),'');  //      33
    $autoriza       =        siNull($app->request->post('AUTORIZA'),'');  //    34
    $motivoaut      =        siNull($app->request->post('MOTIVOAUT'),'');  //   35
    $nrocredito     =        siNull($app->request->post('NROCREDITO'),'');  //  36
    $anticipo       =        siNull($app->request->post('ANTICIPO'),'');  //    37
    $estacion       =        siNull($app->request->post('ESTACION'),'');  //    38
    $bonifxref      =        siNull($app->request->post('BONIFXREF'),'');  //   39
    $gastosfin      =        siNull($app->request->post('GASTOSFIN'),'');  //   40
    $saldocuo       =        siNull($app->request->post('SALDOCUO'),'');  //    41
    $saldopun       =        siNull($app->request->post('SALDOPUN'),'');  //    42
    $descuento      =        siNull($app->request->post('DESCUENTO'),'');  //   43
    $tipocli        =        siNull($app->request->post('TIPOCLI'),'');  //     44
    $fondoc         =        siNull($app->request->post('FONDOC'),'');  //      45
    $fondoc1        =        siNull($app->request->post('FONDOC1'),'');  //     46
    $cargoven       =        siNull($app->request->post('CARGOVEN'),'');  //    47
    $documenta      =        siNull($app->request->post('DOCUMENTA'),'');  //   48
    $vendedor       =        siNull($app->request->post('VENDEDOR'),'');  //    49
    $usuario        =        siNull($app->request->post('USUARIO'),'');  //     50
    $falta          =        siNull($app->request->post('FALTA'),'');  //       51
    $halta          =        siNull($app->request->post('HALTA'),'');  //       52
    $garante        =        siNull($app->request->post('GARANTE'),'');  //     53
    $formapag       =        siNull($app->request->post('FORMAPAG'),'');  //    54
    $descpag        =        siNull($app->request->post('DESCPAG'),'');  //     55
    $claveIns       =        siNull($app->request->post('CLAVEINS'),'');  //    56

    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

            $connection = getConnection();
            $connection->exec('set character set utf8');

            $dbh = $connection->prepare('SELECT prestam FROM rechazos WHERE prestam = ?');
            $dbh->bindParam(1, $prestam);
            $dbh->execute();
            $recordcountRch = $dbh->rowCount();

            $dbh = $connection->prepare('SELECT prestam FROM creditos WHERE prestam = ?');
            $dbh->bindParam(1, $prestam);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0 && $recordcountRch==0){

               $sql = $sql.'INSERT INTO creditos ( ';
               $sql = $sql.'prestam        , ';                    //01
               $sql = $sql.'cliente        , ';                    //02
               $sql = $sql.'lote           , ';                    //03
               $sql = $sql.'plan           , ';                    //04
               $sql = $sql.'feclot         , ';                    //05
               $sql = $sql.'comercio       , ';                    //06
               $sql = $sql.'fecha          , ';                    //07
               $sql = $sql.'capital        , ';                    //08
               $sql = $sql.'gastos         , ';                    //09
               $sql = $sql.'comision       , ';                    //10
               $sql = $sql.'pricuot        , ';                    //11
               $sql = $sql.'cancuot        , ';                    //12
               $sql = $sql.'ultcuot        , ';                    //13
               $sql = $sql.'impcuot        , ';                    //14
               $sql = $sql.'ajustado       , ';                    //15
               $sql = $sql.'juicio         , ';                    //16
               $sql = $sql.'factura        , ';                    //17
               $sql = $sql.'tipfac         , ';                    //18
               $sql = $sql.'impocup        , ';                    //19
               $sql = $sql.'recorri        , ';                    //20
               $sql = $sql.'codvie         , ';                    //21
               $sql = $sql.'gastoven       , ';                    //22
               $sql = $sql.'fecprivenc     , ';                    //23
               $sql = $sql.'cappagado      , ';                    //24
               $sql = $sql.'adelanref      , ';                    //25
               $sql = $sql.'observac       , ';                    //26
               $sql = $sql.'cargesref      , ';                    //27
               $sql = $sql.'cobcuoade      , ';                    //28
               $sql = $sql.'cobgastos      , ';                    //29
               $sql = $sql.'ordpago        , ';                    //30
               $sql = $sql.'fecpago        , ';                    //31
               $sql = $sql.'caida          , ';                    //32
               $sql = $sql.'estado         , ';                    //33
               $sql = $sql.'autoriza       , ';                    //34
               $sql = $sql.'motivoaut      , ';                    //35
               $sql = $sql.'nrocredito     , ';                    //36
               $sql = $sql.'anticipo       , ';                    //37
               $sql = $sql.'estacion       , ';                    //38
               $sql = $sql.'bonifxref      , ';                    //39
               $sql = $sql.'gastosfin      , ';                    //40
               $sql = $sql.'saldocuo       , ';                    //41
               $sql = $sql.'saldopun       , ';                    //42
               $sql = $sql.'descuento      , ';                    //43
               $sql = $sql.'tipocli        , ';                    //44
               $sql = $sql.'fondoc         , ';                    //45
               $sql = $sql.'fondoc1        , ';                    //46
               $sql = $sql.'cargoven       , ';                    //47
               $sql = $sql.'documenta      , ';                    //48
               $sql = $sql.'vendedor       , ';                    //49
               $sql = $sql.'usuario        , ';                    //50
               $sql = $sql.'falta          , ';                    //51
               $sql = $sql.'halta          , ';                    //52
               $sql = $sql.'garante        , ';                    //53
               $sql = $sql.'formapag       , ';                    //54
               $sql = $sql.'descpag        , ';                    //55
               $sql = $sql.'claveIns         ';                    //56

               $sql = $sql.') VALUES( ';

               $sql = $sql.':prestam        , ';                     //01
               $sql = $sql.':cliente        , ';                     //02
               $sql = $sql.':lote           , ';                     //03
               $sql = $sql.':plan           , ';                     //04
               $sql = $sql.':feclot         , ';                     //05
               $sql = $sql.':comercio       , ';                     //06
               $sql = $sql.':fecha          , ';                     //07
               $sql = $sql.':capital        , ';                     //08
               $sql = $sql.':gastos         , ';                     //09
               $sql = $sql.':comision       , ';                     //10
               $sql = $sql.':pricuot        , ';                     //11
               $sql = $sql.':cancuot        , ';                     //12
               $sql = $sql.':ultcuot        , ';                     //13
               $sql = $sql.':impcuot        , ';                     //14
               $sql = $sql.':ajustado       , ';                     //15
               $sql = $sql.':juicio         , ';                     //16
               $sql = $sql.':factura        , ';                     //17
               $sql = $sql.':tipfac         , ';                     //18
               $sql = $sql.':impocup        , ';                     //19
               $sql = $sql.':recorri        , ';                     //20
               $sql = $sql.':codvie         , ';                     //21
               $sql = $sql.':gastoven       , ';                     //22
               $sql = $sql.':fecprivenc     , ';                     //23
               $sql = $sql.':cappagado      , ';                     //24
               $sql = $sql.':adelanref      , ';                     //25
               $sql = $sql.':observac       , ';                     //26
               $sql = $sql.':cargesref      , ';                     //27
               $sql = $sql.':cobcuoade      , ';                     //28
               $sql = $sql.':cobgastos      , ';                     //29
               $sql = $sql.':ordpago        , ';                     //30
               $sql = $sql.':fecpago        , ';                     //31
               $sql = $sql.':caida          , ';                     //32
               $sql = $sql.':estado         , ';                     //33
               $sql = $sql.':autoriza       , ';                     //34
               $sql = $sql.':motivoaut      , ';                     //35
               $sql = $sql.':nrocredito     , ';                     //36
               $sql = $sql.':anticipo       , ';                     //37
               $sql = $sql.':estacion       , ';                     //38
               $sql = $sql.':bonifxref      , ';                     //39
               $sql = $sql.':gastosfin      , ';                     //40
               $sql = $sql.':saldocuo       , ';                     //41
               $sql = $sql.':saldopun       , ';                     //42
               $sql = $sql.':descuento      , ';                     //43
               $sql = $sql.':tipocli        , ';                     //44
               $sql = $sql.':fondoc         , ';                     //45
               $sql = $sql.':fondoc1        , ';                     //46
               $sql = $sql.':cargoven       , ';                     //47
               $sql = $sql.':documenta      , ';                     //48
               $sql = $sql.':vendedor       , ';                     //49
               $sql = $sql.':usuario        , ';                     //50
               $sql = $sql.':falta          , ';                     //51
               $sql = $sql.':halta          , ';                     //52
               $sql = $sql.':garante        , ';                     //53
               $sql = $sql.':formapag       , ';                     //54
               $sql = $sql.':descpag        , ';                     //55
               $sql = $sql.':claveIns         ';                     //56
               $sql = $sql.') ';

               $dbh = $connection->prepare($sql);

               $dbh->bindParam(':prestam', $prestam);            //          01
               $dbh->bindParam(':cliente', $cliente);            //          02
               $dbh->bindParam(':lote', $lote);            //                03
               $dbh->bindParam(':plan', $plan);            //                04
               $dbh->bindParam(':feclot', $feclot);            //            05
               $dbh->bindParam(':comercio', $comercio);            //        06
               $dbh->bindParam(':fecha', $fecha);            //              07
               $dbh->bindParam(':capital', $capital);            //          08
               $dbh->bindParam(':gastos', $gastos);            //            09
               $dbh->bindParam(':comision', $comision);            //        10
               $dbh->bindParam(':pricuot', $pricuot);            //          11
               $dbh->bindParam(':cancuot', $cancuot);            //          12
               $dbh->bindParam(':ultcuot', $ultcuot);            //          13
               $dbh->bindParam(':impcuot', $impcuot);            //          14
               $dbh->bindParam(':ajustado', $ajustado);            //        15
               $dbh->bindParam(':juicio', $juicio);            //            16
               $dbh->bindParam(':factura', $factura);            //          17
               $dbh->bindParam(':tipfac', $tipfac);            //            18
               $dbh->bindParam(':impocup', $impocup);            //          19
               $dbh->bindParam(':recorri', $recorri);            //          20
               $dbh->bindParam(':codvie', $codvie);            //            21
               $dbh->bindParam(':gastoven', $gastoven);            //        22
               $dbh->bindParam(':fecprivenc', $fecprivenc);            //    23
               $dbh->bindParam(':cappagado', $cappagado);            //      24
               $dbh->bindParam(':adelanref', $adelanref);            //      25
               $dbh->bindParam(':observac', $observac);            //        26
               $dbh->bindParam(':cargesref', $cargesref);            //      27
               $dbh->bindParam(':cobcuoade', $cobcuoade);            //      28
               $dbh->bindParam(':cobgastos', $cobgastos);            //      29
               $dbh->bindParam(':ordpago', $ordpago);            //          30
               $dbh->bindParam(':fecpago', $fecpago);            //          31
               $dbh->bindParam(':caida', $caida);            //              32
               $dbh->bindParam(':estado', $estado);            //            33
               $dbh->bindParam(':autoriza', $autoriza);            //        34
               $dbh->bindParam(':motivoaut', $motivoaut);            //      35
               $dbh->bindParam(':nrocredito', $nrocredito);            //    36
               $dbh->bindParam(':anticipo', $anticipo);            //        37
               $dbh->bindParam(':estacion', $estacion);            //        38
               $dbh->bindParam(':bonifxref', $bonifxref);            //      39
               $dbh->bindParam(':gastosfin', $gastosfin);            //      40
               $dbh->bindParam(':saldocuo', $saldocuo);            //        41
               $dbh->bindParam(':saldopun', $saldopun);            //        42
               $dbh->bindParam(':descuento', $descuento);            //      43
               $dbh->bindParam(':tipocli', $tipocli);            //          44
               $dbh->bindParam(':fondoc', $fondoc);            //            45
               $dbh->bindParam(':fondoc1', $fondoc1);            //          46
               $dbh->bindParam(':cargoven', $cargoven);            //        47
               $dbh->bindParam(':documenta', $documenta);            //      48
               $dbh->bindParam(':vendedor', $vendedor);            //        49
               $dbh->bindParam(':usuario', $usuario);            //          50
               $dbh->bindParam(':falta', $falta);            //              51
               $dbh->bindParam(':halta', $halta);            //              52
               $dbh->bindParam(':garante', $garante);            //          53
               $dbh->bindParam(':formapag', $formapag);          //          54
               $dbh->bindParam(':descpag', $descpag);            //          55
               $dbh->bindParam(':claveIns', $claveIns);          //          56

               $dbh->execute();
               $connection = null;
            }

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/creditos/:prestam',function($prestam) use($app)
{
    try{
        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('DELETE FROM creditos WHERE prestam = ?');
            $dbh->bindParam(1, $prestam);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
