<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/cargesfi/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT cargesfi.* '
                    . 'FROM  cargesfi, creditos '
                    . 'WHERE creditos.cliente = ? '
                    . 'AND   cargesfi.credito = creditos.prestam ');

            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }
        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/cargesfi/', function() use($app)
{
    $credito        =        siNull($app->request->post('CREDITO'),'');  //      01
    $cuota          =        siNull($app->request->post('CUOTA'),'');    //      02
    $fecha          =        siNull($app->request->post('FECHA'),'');    //      03
    $hora           =        siNull($app->request->post('HORA'),'');     //      04
    $concepto       =        siNull($app->request->post('CONCEPTO'),'');  //     05
    $importe        =        siNull($app->request->post('IMPORTE'),'');  //      06
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('SELECT * '
                                        .'FROM cargesfi '
                                        .'WHERE credito = :credito '
                                        .'AND cuota = :cuota ' 
                                        .'AND fecha = :fecha '
                                        .'AND hora = :hora ');
            $dbh->bindParam(':credito'  ,$credito);
            $dbh->bindParam(':cuota'    ,$cuota);
            $dbh->bindParam(':fecha'    ,$fecha);
            $dbh->bindParam(':hora'     ,$hora);
            $dbh->execute();


            $recordcount = $dbh->rowCount();


            $sql = '';
            if($recordcount==0){

                $sql = $sql.'INSERT INTO cargesfi ( ';
                $sql = $sql.'credito        , ';                    //01
                $sql = $sql.'cuota          , ';                    //02
                $sql = $sql.'fecha          , ';                    //03
                $sql = $sql.'hora           , ';                    //04
                $sql = $sql.'concepto       , ';                    //05
                $sql = $sql.'importe          ';                    //06
                $sql = $sql.') VALUES( ';
                $sql = $sql.':credito        , ';                   //01
                $sql = $sql.':cuota          , ';                   //02
                $sql = $sql.':fecha          , ';                   //03
                $sql = $sql.':hora           , ';                   //04
                $sql = $sql.':concepto       , ';                   //05
                $sql = $sql.':importe        ) ';                   //06

            }else{

                $sql = $sql.'UPDATE cargesfi SET ';
                $sql = $sql.'concepto        = :concepto,        ';    //05
                $sql = $sql.'importe         = :importe          ';    //06
                $sql = $sql.'WHERE credito = :credito ';                // 01
                $sql = $sql.'AND   cuota   = :cuota ';                  // 02
                $sql = $sql.'AND   fecha   = :fecha ';                  // 03
                $sql = $sql.'AND   hora    = :hora ';                   // 04

            }

            $dbh = $connection->prepare($sql);

            $dbh->bindParam(':credito' , $credito  );            //          01
            $dbh->bindParam(':cuota'   , $cuota    );            //          02
            $dbh->bindParam(':fecha'   , $fecha    );            //          03
            $dbh->bindParam(':hora'    , $hora     );            //          04
            $dbh->bindParam(':concepto', $concepto );            //          05
            $dbh->bindParam(':importe' , $importe  );            //          06

            $dbh->execute();
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
        }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/ccarges/:credito/:cuota/:fecha/:hora',function($credito,$cuota,$fecha,$hora) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        

            $connection = getConnection();
            $connection->exec('set character set utf8');

            $dbh = $connection->prepare('DELETE '
                                        .'FROM cargesfi '
                                        .'WHERE credito = ? '
                                        .'AND   cuota = ? ' 
                                        .'AND   fecha = ? '
                                        .'AND   hora = ? ');
            $dbh->bindParam(1, $credito);
            $dbh->bindParam(2, $cuota);
            $dbh->bindParam(3, $fecha);
            $dbh->bindParam(4, $hora);

            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
