<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/autoriz/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $dbh = $connection->prepare('SELECT * FROM autoriz WHERE cliente = ?');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(my_json_encode($recordset));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});


$app->get('/autoriz/:autoriz', function($autoriz) use($app)
{

    try{
        
        $connection = getConnection();
        $dbh = $connection->prepare('SELECT * FROM autoriz WHERE autoriz = ?');
        $dbh->bindParam(1, $autoriz);
        $dbh->execute();
        $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);
        
        $connection = null;
        
        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(my_json_encode($recordset));
        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/autoriz/', function() use($app)
{

    $autoriz        =        siNull($app->request->post('AUTORIZ'),'');  //     01
    $cliente        =        siNull($app->request->post('CLIENTE'),'');  //     02
    $nombre         =        siNull($app->request->post('NOMBRE'),'');  //      03
    $comercio       =        siNull($app->request->post('COMERCIO'),'');  //    04
    $credito        =        siNull($app->request->post('CREDITO'),'');  //     05
    $cuota          =        siNull($app->request->post('CUOTA'),'');  //       06
    $monto          =        siNull($app->request->post('MONTO'),'');  //       07
    $fecha          =        siNull($app->request->post('FECHA'),'');  //       08
    $descautori     =        siNull($app->request->post('DESCAUTORI'),'');  //  09
    $aprobado       =        siNull($app->request->post('APROBADO'),'');  //    10
    $usuario        =        siNull($app->request->post('USUARIO'),'');  //     11
    $tipo           =        siNull($app->request->post('TIPO'),'');  //        12
    $anticipo       =        siNull($app->request->post('ANTICIPO'),'');  //    13
    $primercr       =        siNull($app->request->post('PRIMERCR'),'');  //    14
    $hora           =        siNull($app->request->post('HORA'),'');  //        15
    $tipoplan       =        siNull($app->request->post('TIPOPLAN'),'');  //    16
    $morosidad      =        siNull($app->request->post('MOROSIDAD'),'');  //   17
    $observa        =        siNull($app->request->post('OBSERVA'),'');  //     18
    $observa2       =        siNull($app->request->post('OBSERVA2'),'');  //    19
    $tipoauto       =        siNull($app->request->post('TIPOAUTO'),'');  //    20
    $motivoauto     =        siNull($app->request->post('MOTIVOAUTO'),'');  //  21
    $claveautor     =        siNull($app->request->post('CLAVEAUTOR'),'');  //  22
    $codpos         =        siNull($app->request->post('CODPOS'),'');  //      23
    $direccion      =        siNull($app->request->post('DIRECCION'),'');  //   24
    $telefo         =        siNull($app->request->post('TELEFO'),'');  //      25
    
    

    try{
        $connection = getConnection();
        $dbh = $connection->prepare("SELECT * FROM autoriz AS `auto` WHERE AUTORIZ = ?"  );
        $dbh->bindParam(1, $autoriz,PDO::PARAM_STR);

        $dbh->execute();
        $recordcount = $dbh->rowCount();
        $sql = '';

//        $app->response->body($recordcount);
        
        if($recordcount==0){
        
            $sql = $sql.'INSERT INTO autoriz ( ';
            $sql = $sql.'autoriz        , ';                    //01
            $sql = $sql.'cliente        , ';                    //02
            $sql = $sql.'nombre         , ';                    //03
            $sql = $sql.'comercio       , ';                    //04
            $sql = $sql.'credito        , ';                    //05
            $sql = $sql.'cuota          , ';                    //06
            $sql = $sql.'monto          , ';                    //07
            $sql = $sql.'fecha          , ';                    //08
            $sql = $sql.'descautori     , ';                    //09
            $sql = $sql.'aprobado       , ';                    //10
            $sql = $sql.'usuario        , ';                    //11
            $sql = $sql.'tipo           , ';                    //12
            $sql = $sql.'anticipo       , ';                    //13
            $sql = $sql.'primercr       , ';                    //14
            $sql = $sql.'hora           , ';                    //15
            $sql = $sql.'tipoplan       , ';                    //16
            $sql = $sql.'morosidad      , ';                    //17
            $sql = $sql.'observa        , ';                    //18
            $sql = $sql.'observa2       , ';                    //19
            $sql = $sql.'tipoauto       , ';                    //20
            $sql = $sql.'motivoauto     , ';                    //21
            $sql = $sql.'claveautor     , ';                    //22
            $sql = $sql.'codpos         , ';                    //23
            $sql = $sql.'direccion      , ';                    //24
            $sql = $sql.'telefo           ';                    //25
            $sql = $sql.') VALUES( ';
            $sql = $sql.':autoriz        , ';                     //01
            $sql = $sql.':cliente        , ';                     //02
            $sql = $sql.':nombre         , ';                     //03
            $sql = $sql.':comercio       , ';                     //04
            $sql = $sql.':credito        , ';                     //05
            $sql = $sql.':cuota          , ';                     //06
            $sql = $sql.':monto          , ';                     //07
            $sql = $sql.':fecha          , ';                     //08
            $sql = $sql.':descautori     , ';                     //09
            $sql = $sql.':aprobado       , ';                     //10
            $sql = $sql.':usuario        , ';                     //11
            $sql = $sql.':tipo           , ';                     //12
            $sql = $sql.':anticipo       , ';                     //13
            $sql = $sql.':primercr       , ';                     //14
            $sql = $sql.':hora           , ';                     //15
            $sql = $sql.':tipoplan       , ';                     //16
            $sql = $sql.':morosidad      , ';                     //17
            $sql = $sql.':observa        , ';                     //18
            $sql = $sql.':observa2       , ';                     //19
            $sql = $sql.':tipoauto       , ';                     //20
            $sql = $sql.':motivoauto     , ';                     //21
            $sql = $sql.':claveautor     , ';                     //22
            $sql = $sql.':codpos         , ';                     //23
            $sql = $sql.':direccion      , ';                     //24
            $sql = $sql.':telefo           ';                     //25
            $sql = $sql.') ';
            

        }else{

            
            $sql = $sql.'UPDATE autoriz SET ';
            $sql = $sql.'autoriz         = :autoriz         , ';    //01
            $sql = $sql.'cliente         = :cliente         , ';    //02
            $sql = $sql.'nombre          = :nombre          , ';    //03
            $sql = $sql.'comercio        = :comercio        , ';    //04
            $sql = $sql.'credito         = :credito         , ';    //05
            $sql = $sql.'cuota           = :cuota           , ';    //06
            $sql = $sql.'monto           = :monto           , ';    //07
            $sql = $sql.'fecha           = :fecha           , ';    //08
            $sql = $sql.'descautori      = :descautori      , ';    //09
            $sql = $sql.'aprobado        = :aprobado        , ';    //10
            $sql = $sql.'usuario         = :usuario         , ';    //11
            $sql = $sql.'tipo            = :tipo            , ';    //12
            $sql = $sql.'anticipo        = :anticipo        , ';    //13
            $sql = $sql.'primercr        = :primercr        , ';    //14
            $sql = $sql.'hora            = :hora            , ';    //15
            $sql = $sql.'tipoplan        = :tipoplan        , ';    //16
            $sql = $sql.'morosidad       = :morosidad       , ';    //17
            $sql = $sql.'observa         = :observa         , ';    //18
            $sql = $sql.'observa2        = :observa2        , ';    //19
            $sql = $sql.'tipoauto        = :tipoauto        , ';    //20
            $sql = $sql.'motivoauto      = :motivoauto      , ';    //21
            $sql = $sql.'claveautor      = :claveautor      , ';    //22
            $sql = $sql.'codpos          = :codpos          , ';    //23
            $sql = $sql.'direccion       = :direccion       , ';    //24
            $sql = $sql.'telefo          = :telefo            ';    //25
            $sql = $sql.'WHERE autoriz = :autoriz';        // 1
            
        }

        $dbh = $connection->prepare($sql);
        
        $dbh->bindParam(':autoriz', $autoriz);            //          01
        $dbh->bindParam(':cliente', $cliente);            //          02
        $dbh->bindParam(':nombre', $nombre);            //            03
        $dbh->bindParam(':comercio', $comercio);            //        04
        $dbh->bindParam(':credito', $credito);            //          05
        $dbh->bindParam(':cuota', $cuota);            //              06
        $dbh->bindParam(':monto', $monto);            //              07
        $dbh->bindParam(':fecha', $fecha);            //              08
        $dbh->bindParam(':descautori', $descautori);            //    09
        $dbh->bindParam(':aprobado', $aprobado);            //        10
        $dbh->bindParam(':usuario', $usuario);            //          11
        $dbh->bindParam(':tipo', $tipo);            //                12
        $dbh->bindParam(':anticipo', $anticipo);            //        13
        $dbh->bindParam(':primercr', $primercr);            //        14
        $dbh->bindParam(':hora', $hora);            //                15
        $dbh->bindParam(':tipoplan', $tipoplan);            //        16
        $dbh->bindParam(':morosidad', $morosidad);            //      17
        $dbh->bindParam(':observa', $observa);            //          18
        $dbh->bindParam(':observa2', $observa2);            //        19
        $dbh->bindParam(':tipoauto', $tipoauto);            //        20
        $dbh->bindParam(':motivoauto', $motivoauto);            //    21
        $dbh->bindParam(':claveautor', $claveautor);            //    22
        $dbh->bindParam(':codpos', $codpos);            //            23
        $dbh->bindParam(':direccion', $direccion);            //      24
        $dbh->bindParam(':telefo', $telefo);            //            25
        
        $dbh->execute();
        $connection = null;


        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(json_encode(array(array('estado'=>'OK'))));
        

        }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
    

});

$app->delete('/autoriz/:autoriz',function($autoriz) use($app)
{
    try{
        
        $connection = getConnection();
        $dbh = $connection->prepare('DELETE FROM autoriz WHERE autoriz = ?');
        $dbh->bindParam(1, $autoriz);
        $dbh->execute();

        $connection = null;
        
        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(json_encode(array(array('estado'=>'OK'))));
        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
