<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/ccarges/:codigo', function($codigo) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT * '
                    . 'FROM  CCARGES '
                    . 'WHERE codigo = ? ');
            $dbh->bindParam(1, $codigo);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }
        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/ccarges/', function() use($app)
{
    $codigo         =        siNull($app->request->post('CODIGO'),'');  //      01
    $descri         =        siNull($app->request->post('DESCRI'),'');  //      02
    $importe        =        siNull($app->request->post('IMPORTE'),''); //      03
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('SELECT codigo FROM ccarges WHERE codigo = ?');
            $dbh->bindParam(1, $codigo);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0){

                $sql = $sql.'INSERT INTO ccarges ( ';
                $sql = $sql.'codigo         , ';                    //01
                $sql = $sql.'descri         , ';                    //02
                $sql = $sql.'importe          ';                    //03
                $sql = $sql.') VALUES( ';
                $sql = $sql.':codigo         , ';                     //01
                $sql = $sql.':descri         , ';                     //02
                $sql = $sql.':importe          ';                    //03
                $sql = $sql.') ';

            }else{

                $sql = $sql.'UPDATE ccarges SET ';
                $sql = $sql.'descri          = :descri,          ';    //02
                $sql = $sql.'importe         = :importe          ';    //02
                $sql = $sql.'WHERE codigo = :codigo ';                 // 1

            }

            $dbh = $connection->prepare($sql);

            $dbh->bindParam(':codigo', $codigo);            //            01
            $dbh->bindParam(':descri', $descri);            //            02
            $dbh->bindParam(':importe', $importe);          //            03

            $dbh->execute();
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
        }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/ccarges/:codigo',function($codigo) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        

            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('DELETE FROM ccarges WHERE codigo = ?');
            $dbh->bindParam(1, $codigo);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
