<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/envideta/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT * '
                    . 'FROM envideta '
                    . 'WHERE cliente = ? ');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }
        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/envideta/', function() use($app)
{
    $credito        =        siNull($app->request->post('CREDITO'),'');    //     01
    $comercio       =        siNull($app->request->post('COMERCIO'),'');   //     02
    $envio          =        siNull($app->request->post('ENVIO'),'');      //     03
    $observa        =        siNull($app->request->post('OBSERVA'),'');    //     04
    $importe        =        siNull($app->request->post('IMPORTE'),'');    //     05
    $baja           =        siNull($app->request->post('BAJA'),'');       //     06
    $fecha_vto      =        siNull($app->request->post('FECHA_VTO'),'');  //     07
    $fecha_alta     =        siNull($app->request->post('FECHA_ALTA'),''); //     08
    $estudio        =        siNull($app->request->post('ESTUDIO'),'');    //     09
    $cliente        =        siNull($app->request->post('CLIENTE'),'');    //     10
    $caida          =        siNull($app->request->post('CAIDA'),'');      //     11
    $upago          =        siNull($app->request->post('UPAGO'),'');      //     12
    $fpromesa       =        siNull($app->request->post('FPROMESA'),'');   //     13
    $evento         =        siNull($app->request->post('EVENTO'),'');     //     14
    $fevento        =        siNull($app->request->post('FEVENTO'),'');    //     15
    $refinan        =        siNull($app->request->post('REFINAN'),'');    //     16
    $usuario        =        siNull($app->request->post('USUARIO'),'');    //     17
    $vto_usu        =        siNull($app->request->post('VTO_USU'),'');    //     18
    $alta_usu       =        siNull($app->request->post('ALTA_USU'),'');   //     19
    $baja_usu       =        siNull($app->request->post('BAJA_USU'),'');   //     20
    $saldo          =        siNull($app->request->post('SALDO'),'');      //     21
    
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('SELECT CREDITO, ENVIO FROM ENVIDETA WHERE CREDITO = ? AND ENVIO = ? ');
            $dbh->bindParam(1, $credito);
            $dbh->bindParam(2, $envio);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0){


                $sql = $sql.'INSERT INTO envideta ( ';
                $sql = $sql.'credito         , ';                    //01
                $sql = $sql.'comercio        , ';                    //02
                $sql = $sql.'envio           , ';                    //03
                $sql = $sql.'observa         , ';                    //04
                $sql = $sql.'importe         , ';                    //05
                $sql = $sql.'baja            , ';                    //06
                $sql = $sql.'fecha_vto       , ';                    //07
                $sql = $sql.'fecha_alta      , ';                    //08
                $sql = $sql.'estudio         , ';                    //09
                $sql = $sql.'cliente         , ';                    //10
                $sql = $sql.'caida           , ';                    //11
                $sql = $sql.'upago           , ';                    //12
                $sql = $sql.'fpromesa        , ';                    //13
                $sql = $sql.'evento          , ';                    //14
                $sql = $sql.'fevento         , ';                    //15
                $sql = $sql.'refinan         , ';                    //16
                $sql = $sql.'usuario         , ';                    //17
                $sql = $sql.'vto_usu         , ';                    //18
                $sql = $sql.'alta_usu        , ';                    //19
                $sql = $sql.'baja_usu        , ';                    //20
                $sql = $sql.'saldo             ';                    //21
                $sql = $sql.') VALUES( ';
                $sql = $sql.':credito        , ';                    //01
                $sql = $sql.':comercio       , ';                    //02
                $sql = $sql.':envio          , ';                    //03
                $sql = $sql.':observa        , ';                    //04
                $sql = $sql.':importe        , ';                    //05
                $sql = $sql.':baja           , ';                    //06
                $sql = $sql.':fecha_vto      , ';                    //07
                $sql = $sql.':fecha_alta     , ';                    //08
                $sql = $sql.':estudio        , ';                    //09
                $sql = $sql.':cliente        , ';                    //10
                $sql = $sql.':caida          , ';                    //11
                $sql = $sql.':upago          , ';                    //12
                $sql = $sql.':fpromesa       , ';                    //13
                $sql = $sql.':evento         , ';                    //14
                $sql = $sql.':fevento        , ';                    //15
                $sql = $sql.':refinan        , ';                    //16
                $sql = $sql.':usuario        , ';                    //17
                $sql = $sql.':vto_usu        , ';                    //18
                $sql = $sql.':alta_usu       , ';                    //19
                $sql = $sql.':baja_usu       , ';                    //20
                $sql = $sql.':saldo            ';                    //21
                $sql = $sql.') ';


            }else{

                $sql = $sql.'UPDATE envideta SET ';
                $sql = $sql.'comercio          = :comercio           ,';    //02
                $sql = $sql.'observa           = :observa            ,';    //04
                $sql = $sql.'importe           = :importe            ,';    //05
                $sql = $sql.'baja              = :baja               ,';    //06
                $sql = $sql.'fecha_vto         = :fecha_vto          ,';    //07
                $sql = $sql.'fecha_alta        = :fecha_alta         ,';    //08
                $sql = $sql.'estudio           = :estudio            ,';    //09
                $sql = $sql.'cliente           = :cliente            ,';    //10
                $sql = $sql.'caida             = :caida              ,';    //11
                $sql = $sql.'upago             = :upago              ,';    //12
                $sql = $sql.'fpromesa          = :fpromesa           ,';    //13
                $sql = $sql.'evento            = :evento             ,';    //14
                $sql = $sql.'fevento           = :fevento            ,';    //15
                $sql = $sql.'refinan           = :refinan            ,';    //16
                $sql = $sql.'usuario           = :usuario            ,';    //17
                $sql = $sql.'vto_usu           = :vto_usu            ,';    //18
                $sql = $sql.'alta_usu          = :alta_usu           ,';    //19
                $sql = $sql.'baja_usu          = :baja_usu           ,';    //20
                $sql = $sql.'saldo             = :saldo               ';    //21
                $sql = $sql.'WHERE credito     = :credito ';               // 01
                $sql = $sql.'and   envio       = :envio ';                 // 03

            }

            $dbh = $connection->prepare($sql);

            $dbh->bindParam(':credito',   $credito);            //            01
            $dbh->bindParam(':comercio',  $comercio);           //            02
            $dbh->bindParam(':envio',     $envio);              //            03
            $dbh->bindParam(':observa',   $observa);            //            04
            $dbh->bindParam(':importe',   $importe);            //            05
            $dbh->bindParam(':baja',      $baja);               //            06
            $dbh->bindParam(':fecha_vto', $fecha_vto);          //            07
            $dbh->bindParam(':fecha_alta',$fecha_alta);         //            08
            $dbh->bindParam(':estudio'   ,$estudio);            //            09
            $dbh->bindParam(':cliente'   ,$cliente);            //            10
            $dbh->bindParam(':caida'     ,$caida);              //            11
            $dbh->bindParam(':upago'     ,$upago);              //            12
            $dbh->bindParam(':fpromesa'  ,$fpromesa);           //            13
            $dbh->bindParam(':evento'    ,$evento);             //            14
            $dbh->bindParam(':fevento'   ,$fevento);            //            15
            $dbh->bindParam(':refinan'   ,$refinan);            //            16
            $dbh->bindParam(':usuario'   ,$usuario);            //            17
            $dbh->bindParam(':vto_usu'   ,$vto_usu);            //            18
            $dbh->bindParam(':alta_usu'  ,$alta_usu);           //            19
            $dbh->bindParam(':baja_usu'  ,$baja_usu);           //            20
            $dbh->bindParam(':saldo'     ,$saldo);              //            21

            $dbh->execute();
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
        }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
});

$app->delete('/envideta/:credito/:envio',function($credito,$envio) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        

            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('DELETE FROM envideta WHERE credito = ? and envio = ? ');
            $dbh->bindParam(1, $credito);
            $dbh->bindParam(2, $envio);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
