<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/client3d/:comercio', function($comercio) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
				$fecha = date("Y-m-d");
				
				$dbh = $connection->prepare('SELECT * FROM client3d WHERE comercio = ?   AND FECHA= ? ');

            $dbh->bindParam(1, $comercio);
            $dbh->bindParam(2, $fecha);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            foreach($recordset as $registro ){
                foreach($registro as $campo=>$valor){
                    $valor = utf8_encode($valor);
                }
            }
            
            $body = json_encode($recordset);
            
            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body($body);
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});



