<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/plastico/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT * FROM plastico WHERE cliente = ?');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/plastico/', function() use($app)
{

    $codigo         =        siNull($app->request->post('CODIGO'),'');  //      01
    $cliente        =        siNull($app->request->post('CLIENTE'),'');  //     02
    $falta          =        siNull($app->request->post('FALTA'),'');  //       03
    $fentrega       =        siNull($app->request->post('FENTREGA'),'');  //    04
    $fbaja          =        siNull($app->request->post('FBAJA'),'');  //       05
    $comercio       =        siNull($app->request->post('COMERCIO'),'');  //    06
    $cupoini        =        siNull($app->request->post('CUPOINI'),'');  //     07
    $cupoven        =        siNull($app->request->post('CUPOVEN'),'');  //     08
    $fvencimien     =        siNull($app->request->post('FVENCIMIEN'),'');  //  09
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT codigo FROM plastico WHERE codigo = ?');
            $dbh->bindParam(1, $codigo);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0){

                $sql = $sql.'INSERT INTO plastico ( ';
                $sql = $sql.'codigo         , ';                    //01
                $sql = $sql.'cliente        , ';                    //02
                $sql = $sql.'falta          , ';                    //03
                $sql = $sql.'fentrega       , ';                    //04
                $sql = $sql.'fbaja          , ';                    //05
                $sql = $sql.'comercio       , ';                    //06
                $sql = $sql.'cupoini        , ';                    //07
                $sql = $sql.'cupoven        , ';                    //08
                $sql = $sql.'fvencimien       ';                    //09
                $sql = $sql.') VALUES( ';
                $sql = $sql.':codigo         , ';                     //01
                $sql = $sql.':cliente        , ';                     //02
                $sql = $sql.':falta          , ';                     //03
                $sql = $sql.':fentrega       , ';                     //04
                $sql = $sql.':fbaja          , ';                     //05
                $sql = $sql.':comercio       , ';                     //06
                $sql = $sql.':cupoini        , ';                     //07
                $sql = $sql.':cupoven        , ';                     //08
                $sql = $sql.':fvencimien       ';                     //09
                $sql = $sql.') ';

            }else{

                $sql = $sql.'UPDATE plastico SET ';
                $sql = $sql.'cliente         = :cliente         , ';    //02
                $sql = $sql.'falta           = :falta           , ';    //03
                $sql = $sql.'fentrega        = :fentrega        , ';    //04
                $sql = $sql.'fbaja           = :fbaja           , ';    //05
                $sql = $sql.'comercio        = :comercio        , ';    //06
                $sql = $sql.'cupoini         = :cupoini         , ';    //07
                $sql = $sql.'cupoven         = :cupoven         , ';    //08
                $sql = $sql.'fvencimien      = :fvencimien       ';    //09
                $sql = $sql.'WHERE codigo = :codigo';        // 1

            }

            $dbh = $connection->prepare($sql);

            $dbh->bindParam(':codigo', $codigo);            //            01
            $dbh->bindParam(':cliente', $cliente);            //          02
            $dbh->bindParam(':falta', $falta);            //              03
            $dbh->bindParam(':fentrega', $fentrega);            //        04
            $dbh->bindParam(':fbaja', $fbaja);            //              05
            $dbh->bindParam(':comercio', $comercio);            //        06
            $dbh->bindParam(':cupoini', $cupoini);            //          07
            $dbh->bindParam(':cupoven', $cupoven);            //          08
            $dbh->bindParam(':fvencimien', $fvencimien);            //    09

            $dbh->execute();
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    }
    catch(PDOException $e)
    {
            echo 'Error: ' . $e->getMessage();
    }
});

$app->delete('/plastico/:codigo',function($codigo) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('DELETE FROM plastico WHERE codigo = ?');
            $dbh->bindParam(1, $codigo);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
