<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/veritele/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

            $connection = getConnection();
            $dbh = $connection->prepare('SELECT * FROM veritele WHERE cliente = ?');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(my_json_encode($recordset));
        }
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }

});


$app->get('/veritele/:codigo/:comercio', function($codigo, $comercio) use($app)
{

    try{

        $connection = getConnection();
        $dbh = $connection->prepare('SELECT * FROM veritele WHERE codigo = ? and comercio= ?');
        $dbh->bindParam(1, $codigo);
        $dbh->bindParam(2, $comercio);
        $dbh->execute();
        $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

        $connection = null;

        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(my_json_encode($recordset));

    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }

});

$app->post('/veritele/', function() use($app)
{

    $codigo         =        siNull($app->request->post('CODIGO'),'');   //     01
    $comercio       =        siNull($app->request->post('COMERCIO'),'');  //    02
    $cliente        =        siNull($app->request->post('CLIENTE'),'');  //     03
    $fecha          =        siNull($app->request->post('FECHA'),'');  //       04
    $tipo           =        siNull($app->request->post('TIPO'),'');  //        05
    $telefono       =        siNull($app->request->post('TELEFONO'),'');  //    06
    $verifica       =        siNull($app->request->post('VERIFICA'),'');  //    07
    $respuesta      =        siNull($app->request->post('RESPUESTA'),'');  //   08


    try{
        $connection = getConnection();
        $dbh = $connection->prepare("SELECT * FROM veritele WHERE CODIGO=? AND COMERCIO=? LIMIT 1"  );
        $dbh->bindParam(1, $codigo, PDO::PARAM_STR);
        $dbh->bindParam(2, $comercio, PDO::PARAM_STR);

        $dbh->execute();
	$recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);



        $recordcount = $dbh->rowCount();

        $sql = '';

        if($recordcount==0){

            $sql = $sql.'INSERT INTO veritele ( ';
            $sql = $sql.'codigo         , ';                    //01
            $sql = $sql.'comercio       , ';                    //02
            $sql = $sql.'cliente        , ';                    //03
            $sql = $sql.'fecha          , ';                    //04
            $sql = $sql.'tipo           , ';                    //05
            $sql = $sql.'telefono       , ';                    //06
            $sql = $sql.'verifica       , ';                    //07
            $sql = $sql.'respuesta        ';                    //08
            $sql = $sql.') VALUES( ';
            $sql = $sql.':codigo         , ';                     //01
            $sql = $sql.':comercio       , ';                     //02
            $sql = $sql.':cliente        , ';                     //03
            $sql = $sql.':fecha          , ';                     //04
            $sql = $sql.':tipo           , ';                     //05
            $sql = $sql.':telefono       , ';                     //06
            $sql = $sql.':verifica       , ';                     //07
            $sql = $sql.':respuesta        ';                     //08
            $sql = $sql.') ';



        }else{

	   $sql = $sql.'UPDATE veritele SET ';
           $sql = $sql.'fecha           = :fecha           , ';    //08
           $sql = $sql.'cliente         = :cliente         , ';    //08
           $sql = $sql.'tipo            = :tipo            , ';    //08
           $sql = $sql.'cliente         = :cliente         , ';    //08
           $sql = $sql.'verifica        = :verifica        , ';    //08
           $sql = $sql.'respuesta       = :respuesta        ';    //08
           $sql = $sql.'WHERE codigo =:codigo and comercio=:comercio ';   // 1 y 2
        }

        $dbh = $connection->prepare($sql);

        $dbh->bindParam(':codigo', $codigo);            //          01
        $dbh->bindParam(':comercio', $comercio);            //          02
        $dbh->bindParam(':cliente', $cliente);            //            03
        $dbh->bindParam(':fecha', $fecha);            //        04
        $dbh->bindParam(':tipo', $tipo);            //          05
        $dbh->bindParam(':telefono', $telefono);            //              06
        $dbh->bindParam(':verifica', $verifica);            //              07
        $dbh->bindParam(':respuesta', $respuesta);            //              08

        $dbh->execute();
        $connection = null;


        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(json_encode(array(array('estado'=>'OK'))));


        }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }


});

$app->delete('/veritele/:codigo/:comercio',function($codigo, $comercio) use($app)
{
    try{

        $connection = getConnection();
        $dbh = $connection->prepare('DELETE FROM veritele WHERE codigo = ? and comercio = ?');
        $dbh->bindParam(1, $codigo);
        $dbh->bindParam(2, $comercio);
        $dbh->execute();

        $connection = null;

        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(json_encode(array(array('estado'=>'OK'))));

    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
