<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/refbaja/:cliente', function($cliente) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {

        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT ref.* FROM refbaja ref, crebaja cre '
                    . 'WHERE ref.refinan = cre.prestam '
                    . 'AND cre.cliente = ? ');
            $dbh->bindParam(1, $cliente);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
        
$app->post('/refbaja/', function() use($app)
{

    $refinan        =        siNull($app->request->post('REFINAN'),'');  //     01
    $credito        =        siNull($app->request->post('CREDITO'),'');  //     02
        
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT refinan, credito '
                    . 'FROM refbaja '
                    . 'WHERE refinan = ? '
                    . 'AND credito = ? ');
            $dbh->bindParam(1, $refinan);
            $dbh->bindParam(2, $credito);
            $dbh->execute();
            $recordcount = $dbh->rowCount();
            $sql = '';
            if($recordcount==0){

                $sql = $sql.'INSERT INTO refbaja ( ';
                $sql = $sql.'refinan        , ';                    //01
                $sql = $sql.'credito          ';                    //02
                $sql = $sql.') VALUES( ';
                $sql = $sql.':refinan        , ';                     //01
                $sql = $sql.':credito          ';                     //02
                $sql = $sql.') ';


                $dbh = $connection->prepare($sql);

                $dbh->bindParam(':refinan', $refinan);            //          01
                $dbh->bindParam(':credito', $credito);            //          02

                $dbh->execute();
            }
            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }
    }
    catch(PDOException $e)
    {
            echo 'Error: ' . $e->getMessage();
    }
});

$app->delete('/refbaja/:refinan/:credito',function($refinan, $credito) use($app)
{
    try{
        
        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {


        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('DELETE FROM refbaja '
                    . 'WHERE refinan = ? '
                    . 'AND credito = ? ');
            $dbh->bindParam(1, $refinan);
            $dbh->bindParam(2, $credito);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});
