<?php
if(!defined('SPECIALCONSTANT')) die('Acceso Denegado');

$app->get('/clientes/:numero', function($numero) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            
            $dbh = $connection->prepare('SELECT * FROM clientes WHERE numero = ?');
            $dbh->bindParam(1, $numero);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            foreach($recordset as $registro ){
                foreach($registro as $campo=>$valor){
                    $valor = utf8_encode($valor);
                }
            }
            
            $body = json_encode($recordset);
            
            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body($body);
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});





$app->post('/clientes/', function() use($app)
{

    $numero         =        siNull($app->request->post('NUMERO'),'');  //      01
    $nombre         =        siNull($app->request->post('NOMBRE'),'');  //      02
    $direccion      =        siNull($app->request->post('DIRECCION'),'');  //   03
    $ecalles        =        siNull($app->request->post('ECALLES'),'');  //     04
    $localidad      =        siNull($app->request->post('LOCALIDAD'),'');  //   05
    $barrio         =        siNull($app->request->post('BARRIO'),'');  //      06
    $codpos         =        siNull($app->request->post('CODPOS'),'');  //      07
    $telefo         =        siNull($app->request->post('TELEFO'),'');  //      08
    $empresa        =        siNull($app->request->post('EMPRESA'),'');  //     09
    $edirecc        =        siNull($app->request->post('EDIRECC'),'');  //     10
    $eecalle        =        siNull($app->request->post('EECALLE'),'');  //     11
    $ecodpos        =        siNull($app->request->post('ECODPOS'),'');  //     12
    $elocali        =        siNull($app->request->post('ELOCALI'),'');  //     13
    $ebarrio        =        siNull($app->request->post('EBARRIO'),'');  //     14
    $etelefo        =        siNull($app->request->post('ETELEFO'),'');  //     15
    $ingmen         =        siNull($app->request->post('INGMEN'),'');  //      16
    $observac       =        siNull($app->request->post('OBSERVAC'),'');  //    17
    $targeta        =        siNull($app->request->post('TARGETA'),'');  //     18
    $juicio         =        siNull($app->request->post('JUICIO'),'');  //      19
    $tipiva         =        siNull($app->request->post('TIPIVA'),'');  //      20
    $nrocui         =        siNull($app->request->post('NROCUI'),'');  //      21
    $cantcred       =        siNull($app->request->post('CANTCRED'),'');  //    22
    $categoria      =        siNull($app->request->post('CATEGORIA'),'');  //   23
    $sexo           =        siNull($app->request->post('SEXO'),'');  //        24
    $tipo           =        siNull($app->request->post('TIPO'),'');  //        25
    $cuil           =        siNull($app->request->post('CUIL'),'');  //        26
    $valcli         =        siNull($app->request->post('VALCLI'),'');  //      27
    $fecinglab      =        siNull($app->request->post('FECINGLAB'),'');  //   28
    $fecha          =        siNull($app->request->post('FECHA'),'');  //       29
    $codvie         =        siNull($app->request->post('CODVIE'),'');  //      30
    $vivienda       =        siNull($app->request->post('VIVIENDA'),'');  //    31
    $telefo1        =        siNull($app->request->post('TELEFO1'),'');  //     32
    $etelefo1       =        siNull($app->request->post('ETELEFO1'),'');  //    33
    $mail           =        siNull($app->request->post('MAIL'),'');  //        34
    $email          =        siNull($app->request->post('EMAIL'),'');  //       35
    $telefo2        =        siNull($app->request->post('TELEFO2'),'');  //     36
    $codbar         =        siNull($app->request->post('CODBAR'),'');  //      37
    $ecodbar        =        siNull($app->request->post('ECODBAR'),'');  //     38
    $cuit           =        siNull($app->request->post('CUIT'),'');  //        39
    $mail2          =        siNull($app->request->post('MAIL2'),'');  //       40
    $instagram      =        siNull($app->request->post('INSTAGRAM'),'');  //   41
    $twitter        =        siNull($app->request->post('TWITTER'),'');  //     42
    $facebook       =        siNull($app->request->post('FACEBOOK'),'');  //    43
        
    try{
        $connection = getConnection();
        $dbh = $connection->prepare('SELECT numero FROM clientes WHERE numero = ?');
        $dbh->bindParam(1, $numero);
        $dbh->execute();
        $recordcount = $dbh->rowCount();
        $sql = '';
        if($recordcount==0){
            
            $sql = $sql.'INSERT INTO clientes ( ';
            $sql = $sql.'numero         , ';                    //01
            $sql = $sql.'nombre         , ';                    //02
            $sql = $sql.'direccion      , ';                    //03
            $sql = $sql.'ecalles        , ';                    //04
            $sql = $sql.'localidad      , ';                    //05
            $sql = $sql.'barrio         , ';                    //06
            $sql = $sql.'codpos         , ';                    //07
            $sql = $sql.'telefo         , ';                    //08
            $sql = $sql.'empresa        , ';                    //09
            $sql = $sql.'edirecc        , ';                    //10
            $sql = $sql.'eecalle        , ';                    //11
            $sql = $sql.'ecodpos        , ';                    //12
            $sql = $sql.'elocali        , ';                    //13
            $sql = $sql.'ebarrio        , ';                    //14
            $sql = $sql.'etelefo        , ';                    //15
            $sql = $sql.'ingmen         , ';                    //16
            $sql = $sql.'observac       , ';                    //17
            $sql = $sql.'targeta        , ';                    //18
            $sql = $sql.'juicio         , ';                    //19
            $sql = $sql.'tipiva         , ';                    //20
            $sql = $sql.'nrocui         , ';                    //21
            $sql = $sql.'cantcred       , ';                    //22
            $sql = $sql.'categoria      , ';                    //23
            $sql = $sql.'sexo           , ';                    //24
            $sql = $sql.'tipo           , ';                    //25
            $sql = $sql.'cuil           , ';                    //26
            $sql = $sql.'valcli         , ';                    //27
            $sql = $sql.'fecinglab      , ';                    //28
            $sql = $sql.'fecha          , ';                    //29
            $sql = $sql.'codvie         , ';                    //30
            $sql = $sql.'vivienda       , ';                    //31
            $sql = $sql.'telefo1        , ';                    //32
            $sql = $sql.'etelefo1       , ';                    //33
            $sql = $sql.'mail           , ';                    //34
            $sql = $sql.'email          , ';                    //35
            $sql = $sql.'telefo2        , ';                    //36
            $sql = $sql.'codbar         , ';                    //37
            $sql = $sql.'ecodbar        , ';                    //38
            $sql = $sql.'cuit           , ';                    //39
            $sql = $sql.'mail2          , ';                    //40
            $sql = $sql.'instagram      , ';                    //41
            $sql = $sql.'twitter        , ';                    //42
            $sql = $sql.'facebook         ';                    //43
            $sql = $sql.') VALUES( ';
            $sql = $sql.':numero         , ';                     //01
            $sql = $sql.':nombre         , ';                     //02
            $sql = $sql.':direccion      , ';                     //03
            $sql = $sql.':ecalles        , ';                     //04
            $sql = $sql.':localidad      , ';                     //05
            $sql = $sql.':barrio         , ';                     //06
            $sql = $sql.':codpos         , ';                     //07
            $sql = $sql.':telefo         , ';                     //08
            $sql = $sql.':empresa        , ';                     //09
            $sql = $sql.':edirecc        , ';                     //10
            $sql = $sql.':eecalle        , ';                     //11
            $sql = $sql.':ecodpos        , ';                     //12
            $sql = $sql.':elocali        , ';                     //13
            $sql = $sql.':ebarrio        , ';                     //14
            $sql = $sql.':etelefo        , ';                     //15
            $sql = $sql.':ingmen         , ';                     //16
            $sql = $sql.':observac       , ';                     //17
            $sql = $sql.':targeta        , ';                     //18
            $sql = $sql.':juicio         , ';                     //19
            $sql = $sql.':tipiva         , ';                     //20
            $sql = $sql.':nrocui         , ';                     //21
            $sql = $sql.':cantcred       , ';                     //22
            $sql = $sql.':categoria      , ';                     //23
            $sql = $sql.':sexo           , ';                     //24
            $sql = $sql.':tipo           , ';                     //25
            $sql = $sql.':cuil           , ';                     //26
            $sql = $sql.':valcli         , ';                     //27
            $sql = $sql.':fecinglab      , ';                     //28
            $sql = $sql.':fecha          , ';                     //29
            $sql = $sql.':codvie         , ';                     //30
            $sql = $sql.':vivienda       , ';                     //31
            $sql = $sql.':telefo1        , ';                     //32
            $sql = $sql.':etelefo1       , ';                     //33
            $sql = $sql.':mail           , ';                     //34
            $sql = $sql.':email          , ';                     //35
            $sql = $sql.':telefo2        , ';                     //36
            $sql = $sql.':codbar         , ';                     //37
            $sql = $sql.':ecodbar        , ';                     //38
            $sql = $sql.':cuit           , ';                     //39
            $sql = $sql.':mail2          , ';                     //40
            $sql = $sql.':instagram      , ';                     //41
            $sql = $sql.':twitter        , ';                     //42
            $sql = $sql.':facebook         ';                     //43
            $sql = $sql.') ';
            
        }else{

            $sql = $sql.'UPDATE clientes SET ';
            $sql = $sql.'nombre          = :nombre          , ';    //02
            $sql = $sql.'direccion       = :direccion       , ';    //03
            $sql = $sql.'ecalles         = :ecalles         , ';    //04
            $sql = $sql.'localidad       = :localidad       , ';    //05
            $sql = $sql.'barrio          = :barrio          , ';    //06
            $sql = $sql.'codpos          = :codpos          , ';    //07
            $sql = $sql.'telefo          = :telefo          , ';    //08
            $sql = $sql.'empresa         = :empresa         , ';    //09
            $sql = $sql.'edirecc         = :edirecc         , ';    //10
            $sql = $sql.'eecalle         = :eecalle         , ';    //11
            $sql = $sql.'ecodpos         = :ecodpos         , ';    //12
            $sql = $sql.'elocali         = :elocali         , ';    //13
            $sql = $sql.'ebarrio         = :ebarrio         , ';    //14
            $sql = $sql.'etelefo         = :etelefo         , ';    //15
            $sql = $sql.'ingmen          = :ingmen          , ';    //16
            $sql = $sql.'observac        = :observac        , ';    //17
            $sql = $sql.'targeta         = :targeta         , ';    //18
            $sql = $sql.'juicio          = :juicio          , ';    //19
            $sql = $sql.'tipiva          = :tipiva          , ';    //20
            $sql = $sql.'nrocui          = :nrocui          , ';    //21
            $sql = $sql.'cantcred        = :cantcred        , ';    //22
            $sql = $sql.'categoria       = :categoria       , ';    //23
            $sql = $sql.'sexo            = :sexo            , ';    //24
            $sql = $sql.'tipo            = :tipo            , ';    //25
            $sql = $sql.'cuil            = :cuil            , ';    //26
            $sql = $sql.'valcli          = :valcli          , ';    //27
            $sql = $sql.'fecinglab       = :fecinglab       , ';    //28
            $sql = $sql.'fecha           = :fecha           , ';    //29
            $sql = $sql.'codvie          = :codvie          , ';    //30
            $sql = $sql.'vivienda        = :vivienda        , ';    //31
            $sql = $sql.'telefo1         = :telefo1         , ';    //32
            $sql = $sql.'etelefo1        = :etelefo1        , ';    //33
            $sql = $sql.'mail            = :mail            , ';    //34
            $sql = $sql.'email           = :email           , ';    //35
            $sql = $sql.'telefo2         = :telefo2         , ';    //36
            $sql = $sql.'codbar          = :codbar          , ';    //37
            $sql = $sql.'ecodbar         = :ecodbar         , ';    //38
            $sql = $sql.'cuit            = :cuit            , ';    //39
            $sql = $sql.'mail2           = :mail2           , ';    //40
            $sql = $sql.'instagram       = :instagram       , ';    //41
            $sql = $sql.'twitter         = :twitter         , ';    //42
            $sql = $sql.'facebook        = :facebook          ';    //43
            $sql = $sql.'WHERE    numero = :numero            ';    // 1

        }

        $dbh = $connection->prepare($sql);
        
        $dbh->bindParam(':numero', $numero);            //            01
        $dbh->bindParam(':nombre', $nombre);            //            02
        $dbh->bindParam(':direccion', $direccion);            //      03
        $dbh->bindParam(':ecalles', $ecalles);            //          04
        $dbh->bindParam(':localidad', $localidad);            //      05
        $dbh->bindParam(':barrio', $barrio);            //            06
        $dbh->bindParam(':codpos', $codpos);            //            07
        $dbh->bindParam(':telefo', $telefo);            //            08
        $dbh->bindParam(':empresa', $empresa);            //          09
        $dbh->bindParam(':edirecc', $edirecc);            //          10
        $dbh->bindParam(':eecalle', $eecalle);            //          11
        $dbh->bindParam(':ecodpos', $ecodpos);            //          12
        $dbh->bindParam(':elocali', $elocali);            //          13
        $dbh->bindParam(':ebarrio', $ebarrio);            //          14
        $dbh->bindParam(':etelefo', $etelefo);            //          15
        $dbh->bindParam(':ingmen', $ingmen);            //            16
        $dbh->bindParam(':observac', $observac);            //        17
        $dbh->bindParam(':targeta', $targeta);            //          18
        $dbh->bindParam(':juicio', $juicio);            //            19
        $dbh->bindParam(':tipiva', $tipiva);            //            20
        $dbh->bindParam(':nrocui', $nrocui);            //            21
        $dbh->bindParam(':cantcred', $cantcred);            //        22
        $dbh->bindParam(':categoria', $categoria);            //      23
        $dbh->bindParam(':sexo', $sexo);            //                24
        $dbh->bindParam(':tipo', $tipo);            //                25
        $dbh->bindParam(':cuil', $cuil);            //                26
        $dbh->bindParam(':valcli', $valcli);            //            27
        $dbh->bindParam(':fecinglab', $fecinglab);            //      28
        $dbh->bindParam(':fecha', $fecha);            //              29
        $dbh->bindParam(':codvie', $codvie);            //            30
        $dbh->bindParam(':vivienda', $vivienda);            //        31
        $dbh->bindParam(':telefo1', $telefo1);            //          32
        $dbh->bindParam(':etelefo1', $etelefo1);            //        33
        $dbh->bindParam(':mail', $mail);            //                34
        $dbh->bindParam(':email', $email);            //              35
        $dbh->bindParam(':telefo2', $telefo2);            //          36
        $dbh->bindParam(':codbar', $codbar);            //            37
        $dbh->bindParam(':ecodbar', $ecodbar);            //          38
        $dbh->bindParam(':cuit', $cuit);            //                39
        $dbh->bindParam(':mail2', $mail2);            //              40
        $dbh->bindParam(':instagram', $instagram);            //      41
        $dbh->bindParam(':twitter', $twitter);            //          42
        $dbh->bindParam(':facebook', $facebook);            //        43
        
        $dbh->execute();
    
		// arreglo lo de la Ñ
		$dbh = $connection->prepare("update clientes set nombre = replace(nombre, '?','Ñ') where clientes.nombre like '%?%'");
		$dbh->execute();
		
		$connection = null;

        $app->response->headers->set('Content-type', 'application/json');
        $app->response->status(200);
        $app->response->body(json_encode(array(array('estado'=>'OK'))));

        }
    catch(PDOException $e)
   {
            echo 'Error: ' . $e->getMessage();
   }
});


$app->delete('/clientes/:numero',function($numero) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');
            $dbh = $connection->prepare('DELETE FROM clientes WHERE numero = ?');
            $dbh->bindParam(1, $numero);
            $dbh->execute();

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode(array(array('estado'=>'OK'))));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
});


$app->get('/clientesxfecha/:desde/:hasta/:comercio', function($desde, $hasta, $comercio) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');

            $sql = "SELECT CLIENTE FROM CREDITOS ".
                    "WHERE FECHA>=:desde ".
                    "AND FECHA <=:hasta ".
                    "AND COMERCIO=:comercio " .
                    "GROUP BY CLIENTE ".
                    "UNION ALL ".
                    "SELECT CRE.CLIENTE FROM CREDITOS CRE, RECIBOS REC ".
                    "WHERE REC.FECHA>=:desde ".
                    "AND REC.FECHA <=:hasta ".
                    "AND CRE.PRESTAM = REC.PRESTAM ".
                    "AND REC.COMERCIO=:comercio ".
                    "GROUP BY CRE.CLIENTE ".
                    "UNION ALL ".
                    "SELECT CLIENTE FROM CREBAJA ".
                    "WHERE FECHA>=:desde " .
                    "AND FECHA <=:hasta ".
                    "AND COMERCIO=:comercio ".
                    "UNION ALL ".
                    "SELECT CRE.CLIENTE FROM CREDITOS CRE, RECBAJA REC ".
                    "WHERE REC.FECHA>=:desde ".
                    "AND REC.FECHA <=:hasta ".
                    "AND CRE.PRESTAM = REC.PRESTAM ". 
                    "AND REC.COMERCIO=:comercio ".
                    "GROUP BY CRE.CLIENTE ";
                    
            $dbh = $connection->prepare($sql);
            $dbh->bindParam(":desde", $desde);
            $dbh->bindParam(":hasta", $hasta);
            $dbh->bindParam(":comercio", $comercio);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});


$app->get('/clientesxfecha/:desde/:hasta', function($desde, $hasta) use($app)
{
    try{

        $header = $app->request->getUserAgent();
        if (!verificarUsuario($header)){

            $app->response->headers->set('Content-type', 'text/plain');
            $app->response->status(401);
            $app->response->body('Usuario no autorizado');
        }
        else {
        
            $connection = getConnection();
            $connection->exec('set character set utf8');

            $sql = "SELECT CLIENTE FROM CREDITOS ".
                    "WHERE FECHA>=:desde ".
                    "AND FECHA <=:hasta ".
                    "GROUP BY CLIENTE ".
                    "UNION ALL ".
                    "SELECT CRE.CLIENTE FROM CREDITOS CRE, RECIBOS REC ".
                    "WHERE REC.FECHA>=:desde ".
                    "AND REC.FECHA <=:hasta ".
                    "AND CRE.PRESTAM = REC.PRESTAM ".
                    "GROUP BY CRE.CLIENTE ".
                    "UNION ALL ".
                    "SELECT CLIENTE FROM CREBAJA ".
                    "WHERE FECHA>=:desde " .
                    "AND FECHA <=:hasta ".
                    "GROUP BY CLIENTE ".
                    "UNION ALL ".
                    "SELECT CRE.CLIENTE FROM CREDITOS CRE, RECBAJA REC ".
                    "WHERE REC.FECHA>=:desde ".
                    "AND REC.FECHA <=:hasta ".
                    "AND CRE.PRESTAM = REC.PRESTAM ". 
                    "GROUP BY CRE.CLIENTE ";
                    
            $dbh = $connection->prepare($sql);
            $dbh->bindParam(":desde", $desde);
            $dbh->bindParam(":hasta", $hasta);
            $dbh->execute();
            $recordset = $dbh->fetchAll(PDO::FETCH_ASSOC);

            $connection = null;

            $app->response->headers->set('Content-type', 'application/json');
            $app->response->status(200);
            $app->response->body(json_encode($recordset));
        }        
    } catch (PDOException $ex) {
        echo 'Error en conexion: '.$ex->getMessage() ;
    }
    
});
